/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.models;

import com.azure.ai.metricsadvisor.administration.models.AnomalySeverity;
import com.azure.ai.metricsadvisor.implementation.util.IncidentHelper;
import com.azure.ai.metricsadvisor.models.AnomalyIncidentStatus;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import java.time.OffsetDateTime;

public final class AnomalyIncident {
    private String id;
    private String dataFeedId;
    private String metricId;
    private String detectionConfigurationId;
    private DimensionKey rootDimensionKey;
    private AnomalySeverity severity;
    private AnomalyIncidentStatus status;
    private OffsetDateTime startTime;
    private OffsetDateTime lastTime;
    private Double valueOfRootNode;
    private Double expectedValueOfRootNode;

    public String getId() {
        return this.id;
    }

    public String getDataFeedId() {
        return this.dataFeedId;
    }

    public String getMetricId() {
        return this.metricId;
    }

    public String getDetectionConfigurationId() {
        return this.detectionConfigurationId;
    }

    public DimensionKey getRootDimensionKey() {
        return this.rootDimensionKey;
    }

    public Double getValueOfRootNode() {
        return this.valueOfRootNode;
    }

    public Double getExpectedValueOfRootNode() {
        return this.expectedValueOfRootNode;
    }

    public AnomalySeverity getSeverity() {
        return this.severity;
    }

    public AnomalyIncidentStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getLastTime() {
        return this.lastTime;
    }

    void setId(String id) {
        this.id = id;
    }

    void setDataFeedId(String dataFeedId) {
        this.dataFeedId = dataFeedId;
    }

    void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    void setDetectionConfigurationId(String detectionConfigurationId) {
        this.detectionConfigurationId = detectionConfigurationId;
    }

    void setRootDimensionKey(DimensionKey rootDimensionKey) {
        this.rootDimensionKey = rootDimensionKey;
    }

    void setValueOfRootNode(Double valueOfRootNode) {
        this.valueOfRootNode = valueOfRootNode;
    }

    void setExpectedValueOfRootNode(Double value) {
        this.expectedValueOfRootNode = value;
    }

    void setSeverity(AnomalySeverity severity) {
        this.severity = severity;
    }

    void setStatus(AnomalyIncidentStatus status) {
        this.status = status;
    }

    void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    void setLastTime(OffsetDateTime lastTime) {
        this.lastTime = lastTime;
    }

    static {
        IncidentHelper.setAccessor(new IncidentHelper.IncidentAccessor(){

            @Override
            public void setId(AnomalyIncident incident, String id) {
                incident.setId(id);
            }

            @Override
            public void setDataFeedId(AnomalyIncident incident, String dataFeedId) {
                incident.setDataFeedId(dataFeedId);
            }

            @Override
            public void setMetricId(AnomalyIncident incident, String metricId) {
                incident.setMetricId(metricId);
            }

            @Override
            public void setDetectionConfigurationId(AnomalyIncident incident, String detectionConfigurationId) {
                incident.setDetectionConfigurationId(detectionConfigurationId);
            }

            @Override
            public void setRootDimensionKey(AnomalyIncident incident, DimensionKey rootDimensionKey) {
                incident.setRootDimensionKey(rootDimensionKey);
            }

            @Override
            public void setValue(AnomalyIncident incident, Double value) {
                incident.setValueOfRootNode(value);
            }

            @Override
            public void setExpectedValue(AnomalyIncident incident, Double value) {
                incident.setExpectedValueOfRootNode(value);
            }

            @Override
            public void setSeverity(AnomalyIncident incident, AnomalySeverity severity) {
                incident.setSeverity(severity);
            }

            @Override
            public void setStatus(AnomalyIncident incident, AnomalyIncidentStatus status) {
                incident.setStatus(status);
            }

            @Override
            public void setStartTime(AnomalyIncident incident, OffsetDateTime startTime) {
                incident.setStartTime(startTime);
            }

            @Override
            public void setLastTime(AnomalyIncident incident, OffsetDateTime lastTime) {
                incident.setLastTime(lastTime);
            }
        });
    }
}

