/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.models;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class DimensionKey {
    private final Map<String, String> dimensions;

    public DimensionKey() {
        this.dimensions = new HashMap<String, String>();
    }

    public DimensionKey(Map<String, String> dimensionNameValue) {
        this.dimensions = new HashMap<String, String>(dimensionNameValue);
    }

    public DimensionKey put(String dimensionName, String dimensionValue) {
        this.dimensions.put(dimensionName, dimensionValue);
        return this;
    }

    public String get(String dimensionName) {
        return this.dimensions.get(dimensionName);
    }

    public DimensionKey remove(String dimensionName) {
        this.dimensions.remove(dimensionName);
        return this;
    }

    public Map<String, String> asMap() {
        return new HashMap<String, String>(this.dimensions);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionKey)) {
            return false;
        }
        DimensionKey otherDimensionKey = (DimensionKey)o;
        if (this.dimensions.size() != otherDimensionKey.dimensions.size()) {
            return false;
        }
        Iterator<Map.Entry<String, String>> itr1 = new TreeMap<String, String>(this.dimensions).entrySet().iterator();
        Iterator<Map.Entry<String, String>> itr2 = new TreeMap<String, String>(otherDimensionKey.dimensions).entrySet().iterator();
        while (itr1.hasNext()) {
            Map.Entry<String, String> entry1 = itr1.next();
            Map.Entry<String, String> entry2 = itr2.next();
            if (entry1.getKey().equals(entry2.getKey()) && entry1.getValue().equals(entry2.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<String, String> entry : this.dimensions.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            int entryHashCode = (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            hashCode += entryHashCode;
        }
        return hashCode;
    }
}

