/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.models;

import com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration;
import com.azure.ai.metricsadvisor.implementation.util.MetricAnomalyFeedbackHelper;
import com.azure.ai.metricsadvisor.models.AnomalyValue;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.ai.metricsadvisor.models.MetricFeedback;
import java.time.OffsetDateTime;

public final class MetricAnomalyFeedback
extends MetricFeedback {
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;
    private final AnomalyValue anomalyValue;
    private AnomalyDetectionConfiguration detectionConfiguration;
    private String detectionConfigurationId;

    public MetricAnomalyFeedback(OffsetDateTime startTime, OffsetDateTime endTime, AnomalyValue anomalyValue) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.anomalyValue = anomalyValue;
    }

    public AnomalyValue getAnomalyValue() {
        return this.anomalyValue;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public AnomalyDetectionConfiguration getDetectionConfiguration() {
        return this.detectionConfiguration;
    }

    public MetricAnomalyFeedback setDetectionConfigurationId(String detectionConfigurationId) {
        this.detectionConfigurationId = detectionConfigurationId;
        return this;
    }

    @Override
    public MetricAnomalyFeedback setDimensionFilter(DimensionKey dimensionFilter) {
        super.setDimensionFilter(dimensionFilter);
        return this;
    }

    public String getDetectionConfigurationId() {
        return this.detectionConfigurationId;
    }

    void setDetectionConfiguration(AnomalyDetectionConfiguration configuration) {
        this.detectionConfiguration = configuration;
    }

    static {
        MetricAnomalyFeedbackHelper.setAccessor(new MetricAnomalyFeedbackHelper.MetricAnomalyFeedbackAccessor(){

            @Override
            public void setDetectionConfiguration(MetricAnomalyFeedback feedback, AnomalyDetectionConfiguration configuration) {
                feedback.setDetectionConfiguration(configuration);
            }
        });
    }
}

