/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants;

import com.azure.ai.openai.assistants.AssistantsClientBuilder;
import com.azure.ai.openai.assistants.implementation.AssistantsClientImpl;
import com.azure.ai.openai.assistants.implementation.MultipartFormDataHelper;
import com.azure.ai.openai.assistants.implementation.OpenAIUtils;
import com.azure.ai.openai.assistants.implementation.accesshelpers.PageableListAccessHelper;
import com.azure.ai.openai.assistants.implementation.models.CreateVectorStoreFileBatchRequest;
import com.azure.ai.openai.assistants.implementation.models.CreateVectorStoreFileRequest;
import com.azure.ai.openai.assistants.implementation.models.FileListResponse;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfAssistant;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfRunStep;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfThreadMessage;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfThreadRun;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfVectorStore;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfVectorStoreFile;
import com.azure.ai.openai.assistants.implementation.models.SubmitToolOutputsToRunRequest;
import com.azure.ai.openai.assistants.implementation.models.UpdateMessageRequest;
import com.azure.ai.openai.assistants.implementation.models.UpdateRunRequest;
import com.azure.ai.openai.assistants.implementation.models.UploadFileRequest;
import com.azure.ai.openai.assistants.implementation.streaming.OpenAIServerSentEvents;
import com.azure.ai.openai.assistants.models.Assistant;
import com.azure.ai.openai.assistants.models.AssistantCreationOptions;
import com.azure.ai.openai.assistants.models.AssistantDeletionStatus;
import com.azure.ai.openai.assistants.models.AssistantThread;
import com.azure.ai.openai.assistants.models.AssistantThreadCreationOptions;
import com.azure.ai.openai.assistants.models.CreateAndRunThreadOptions;
import com.azure.ai.openai.assistants.models.CreateRunOptions;
import com.azure.ai.openai.assistants.models.FileDeletionStatus;
import com.azure.ai.openai.assistants.models.FileDetails;
import com.azure.ai.openai.assistants.models.FilePurpose;
import com.azure.ai.openai.assistants.models.ListSortOrder;
import com.azure.ai.openai.assistants.models.OpenAIFile;
import com.azure.ai.openai.assistants.models.PageableList;
import com.azure.ai.openai.assistants.models.RunStep;
import com.azure.ai.openai.assistants.models.StreamUpdate;
import com.azure.ai.openai.assistants.models.ThreadDeletionStatus;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.ThreadMessageOptions;
import com.azure.ai.openai.assistants.models.ThreadRun;
import com.azure.ai.openai.assistants.models.ToolOutput;
import com.azure.ai.openai.assistants.models.UpdateAssistantOptions;
import com.azure.ai.openai.assistants.models.UpdateAssistantThreadOptions;
import com.azure.ai.openai.assistants.models.VectorStore;
import com.azure.ai.openai.assistants.models.VectorStoreDeletionStatus;
import com.azure.ai.openai.assistants.models.VectorStoreFile;
import com.azure.ai.openai.assistants.models.VectorStoreFileBatch;
import com.azure.ai.openai.assistants.models.VectorStoreFileDeletionStatus;
import com.azure.ai.openai.assistants.models.VectorStoreFileStatusFilter;
import com.azure.ai.openai.assistants.models.VectorStoreOptions;
import com.azure.ai.openai.assistants.models.VectorStoreUpdateOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.IterableStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;

@ServiceClient(builder=AssistantsClientBuilder.class)
public final class AssistantsClient {
    private final AssistantsClientImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createAssistantWithResponse(BinaryData assistantCreationOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createAssistantWithResponse(assistantCreationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listAssistantsWithResponse(RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listAssistantsWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteAssistantWithResponse(String assistantId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteAssistantWithResponse(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Assistant createAssistant(AssistantCreationOptions assistantCreationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Assistant)((BinaryData)this.createAssistantWithResponse(BinaryData.fromObject((Object)assistantCreationOptions), requestOptions).getValue()).toObject(Assistant.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<Assistant> listAssistants(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfAssistant assistantList = (OpenAIPageableListOfAssistant)((BinaryData)this.listAssistantsWithResponse(requestOptions).getValue()).toObject(OpenAIPageableListOfAssistant.class);
        return PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<Assistant> listAssistants() {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfAssistant assistantList = (OpenAIPageableListOfAssistant)((BinaryData)this.listAssistantsWithResponse(requestOptions).getValue()).toObject(OpenAIPageableListOfAssistant.class);
        return PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AssistantDeletionStatus deleteAssistant(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AssistantDeletionStatus)((BinaryData)this.deleteAssistantWithResponse(assistantId, requestOptions).getValue()).toObject(AssistantDeletionStatus.class);
    }

    AssistantsClient(AssistantsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAssistantWithResponse(String assistantId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getAssistantWithResponse(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createThreadWithResponse(BinaryData assistantThreadCreationOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createThreadWithResponse(assistantThreadCreationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getThreadWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getThreadWithResponse(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteThreadWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteThreadWithResponse(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createMessageWithResponse(String threadId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createMessageWithResponse(threadId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listMessagesWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listMessagesWithResponse(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMessageWithResponse(String threadId, String messageId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getMessageWithResponse(threadId, messageId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createRunWithResponse(String threadId, BinaryData createRunOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createRunWithResponse(threadId, createRunOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listRunsWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listRunsWithResponse(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getRunWithResponse(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> submitToolOutputsToRunWithResponse(String threadId, String runId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.submitToolOutputsToRunWithResponse(threadId, runId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.cancelRunWithResponse(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createThreadAndRunWithResponse(BinaryData createAndRunThreadOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createThreadAndRunWithResponse(createAndRunThreadOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRunStepWithResponse(String threadId, String runId, String stepId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getRunStepWithResponse(threadId, runId, stepId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listRunStepsWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listRunStepsWithResponse(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listFilesWithResponse(RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listFilesWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteFileWithResponse(String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteFileWithResponse(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Assistant getAssistant(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Assistant)((BinaryData)this.getAssistantWithResponse(assistantId, requestOptions).getValue()).toObject(Assistant.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AssistantThread createThread(AssistantThreadCreationOptions assistantThreadCreationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (AssistantThread)((BinaryData)this.createThreadWithResponse(BinaryData.fromObject((Object)assistantThreadCreationOptions), requestOptions).getValue()).toObject(AssistantThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AssistantThread getThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AssistantThread)((BinaryData)this.getThreadWithResponse(threadId, requestOptions).getValue()).toObject(AssistantThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadDeletionStatus deleteThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadDeletionStatus)((BinaryData)this.deleteThreadWithResponse(threadId, requestOptions).getValue()).toObject(ThreadDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<ThreadMessage> listMessages(String threadId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfThreadMessage threadMessageList = (OpenAIPageableListOfThreadMessage)((BinaryData)this.listMessagesWithResponse(threadId, requestOptions).getValue()).toObject(OpenAIPageableListOfThreadMessage.class);
        return PageableListAccessHelper.create(threadMessageList.getData(), threadMessageList.getFirstId(), threadMessageList.getLastId(), threadMessageList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<ThreadMessage> listMessages(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfThreadMessage threadMessageList = (OpenAIPageableListOfThreadMessage)((BinaryData)this.listMessagesWithResponse(threadId, requestOptions).getValue()).toObject(OpenAIPageableListOfThreadMessage.class);
        return PageableListAccessHelper.create(threadMessageList.getData(), threadMessageList.getFirstId(), threadMessageList.getLastId(), threadMessageList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage getMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadMessage)((BinaryData)this.getMessageWithResponse(threadId, messageId, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<ThreadRun> listRuns(String threadId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfThreadRun threadRunList = (OpenAIPageableListOfThreadRun)((BinaryData)this.listRunsWithResponse(threadId, requestOptions).getValue()).toObject(OpenAIPageableListOfThreadRun.class);
        return PageableListAccessHelper.create(threadRunList.getData(), threadRunList.getFirstId(), threadRunList.getLastId(), threadRunList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<ThreadRun> listRuns(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfThreadRun threadRunList = (OpenAIPageableListOfThreadRun)((BinaryData)this.listRunsWithResponse(threadId, requestOptions).getValue()).toObject(OpenAIPageableListOfThreadRun.class);
        return PageableListAccessHelper.create(threadRunList.getData(), threadRunList.getFirstId(), threadRunList.getLastId(), threadRunList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun getRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.getRunWithResponse(threadId, runId, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun cancelRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.cancelRunWithResponse(threadId, runId, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun createThreadAndRun(CreateAndRunThreadOptions createAndRunThreadOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.createThreadAndRunWithResponse(BinaryData.fromObject((Object)createAndRunThreadOptions), requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<StreamUpdate> createThreadAndRunStream(CreateAndRunThreadOptions createAndRunThreadOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData inputJson = BinaryData.fromObject((Object)createAndRunThreadOptions);
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = ((BinaryData)this.createThreadAndRunWithResponse(adjustedJson, requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents eventStream = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return new IterableStream(eventStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunStep getRunStep(String threadId, String runId, String stepId) {
        RequestOptions requestOptions = new RequestOptions();
        return (RunStep)((BinaryData)this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).getValue()).toObject(RunStep.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<RunStep> listRunSteps(String threadId, String runId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfRunStep runStepList = (OpenAIPageableListOfRunStep)((BinaryData)this.listRunStepsWithResponse(threadId, runId, requestOptions).getValue()).toObject(OpenAIPageableListOfRunStep.class);
        return PageableListAccessHelper.create(runStepList.getData(), runStepList.getFirstId(), runStepList.getLastId(), runStepList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<RunStep> listRunSteps(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfRunStep runStepList = (OpenAIPageableListOfRunStep)((BinaryData)this.listRunStepsWithResponse(threadId, runId, requestOptions).getValue()).toObject(OpenAIPageableListOfRunStep.class);
        return PageableListAccessHelper.create(runStepList.getData(), runStepList.getFirstId(), runStepList.getLastId(), runStepList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<OpenAIFile> listFiles(FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return ((FileListResponse)((BinaryData)this.listFilesWithResponse(requestOptions).getValue()).toObject(FileListResponse.class)).getData();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<OpenAIFile> listFiles() {
        RequestOptions requestOptions = new RequestOptions();
        return ((FileListResponse)((BinaryData)this.listFilesWithResponse(requestOptions).getValue()).toObject(FileListResponse.class)).getData();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileDeletionStatus deleteFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (FileDeletionStatus)((BinaryData)this.deleteFileWithResponse(fileId, requestOptions).getValue()).toObject(FileDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateAssistantWithResponse(String assistantId, BinaryData updateAssistantOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateAssistantWithResponse(assistantId, updateAssistantOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateThreadWithResponse(String threadId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateThreadWithResponse(threadId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateMessageWithResponse(String threadId, String messageId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateMessageWithResponse(threadId, messageId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateRunWithResponse(String threadId, String runId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateRunWithResponse(threadId, runId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> uploadFileWithResponse(BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.uploadFileWithResponse(request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getFileWithResponse(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Assistant updateAssistant(String assistantId, UpdateAssistantOptions updateAssistantOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Assistant)((BinaryData)this.updateAssistantWithResponse(assistantId, BinaryData.fromObject((Object)updateAssistantOptions), requestOptions).getValue()).toObject(Assistant.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage updateMessage(String threadId, String messageId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest requestObj = new UpdateMessageRequest().setMetadata(metadata);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ThreadMessage)((BinaryData)this.updateMessageWithResponse(threadId, messageId, request, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage updateMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest requestObj = new UpdateMessageRequest();
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ThreadMessage)((BinaryData)this.updateMessageWithResponse(threadId, messageId, request, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun createRun(String threadId, CreateRunOptions createRunOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.createRunWithResponse(threadId, BinaryData.fromObject((Object)createRunOptions), requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun createRun(AssistantThread thread, Assistant assistant) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.createRunWithResponse(thread.getId(), BinaryData.fromObject((Object)new CreateRunOptions(assistant.getId())), requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<StreamUpdate> createRunStream(String threadId, CreateRunOptions createRunOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData inputJson = BinaryData.fromObject((Object)createRunOptions);
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = ((BinaryData)this.createRunWithResponse(threadId, adjustedJson, requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents eventStream = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return new IterableStream(eventStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<StreamUpdate> createRunStream(String threadId, String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData inputJson = BinaryData.fromObject((Object)new CreateRunOptions(assistantId));
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = ((BinaryData)this.createRunWithResponse(threadId, BinaryData.fromObject((Object)adjustedJson), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents eventStream = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return new IterableStream(eventStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun updateRun(String threadId, String runId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest requestObj = new UpdateRunRequest().setMetadata(metadata);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ThreadRun)((BinaryData)this.updateRunWithResponse(threadId, runId, request, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun updateRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest requestObj = new UpdateRunRequest();
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ThreadRun)((BinaryData)this.updateRunWithResponse(threadId, runId, request, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenAIFile getFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (OpenAIFile)((BinaryData)this.getFileWithResponse(fileId, requestOptions).getValue()).toObject(OpenAIFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    OpenAIFile uploadFile(FileDetails file, FilePurpose purpose, String filename) {
        file.setFilename(filename);
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest requestObj = new UploadFileRequest(file, purpose).setFilename(filename);
        BinaryData request = new MultipartFormDataHelper(requestOptions).serializeFileField("file", requestObj.getFile().getContent(), requestObj.getFile().getContentType(), requestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)requestObj.getPurpose())).serializeTextField("filename", requestObj.getFilename()).end().getRequestBody();
        return (OpenAIFile)((BinaryData)this.uploadFileWithResponse(request, requestOptions).getValue()).toObject(OpenAIFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenAIFile uploadFile(FileDetails file, FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest requestObj = new UploadFileRequest(file, purpose);
        BinaryData request = new MultipartFormDataHelper(requestOptions).serializeFileField("file", requestObj.getFile().getContent(), requestObj.getFile().getContentType(), requestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)requestObj.getPurpose())).serializeTextField("filename", requestObj.getFilename()).end().getRequestBody();
        return (OpenAIFile)((BinaryData)this.uploadFileWithResponse(request, requestOptions).getValue()).toObject(OpenAIFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileContentWithResponse(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] getFileContent(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (byte[])((BinaryData)this.getFileContentWithResponse(fileId, requestOptions).getValue()).toObject(byte[].class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<StreamUpdate> submitToolOutputsToRunStream(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest requestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(true);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        Flux streamResponse = ((BinaryData)this.submitToolOutputsToRunWithResponse(threadId, runId, request, requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents openAIServerSentEvents = new OpenAIServerSentEvents((Flux<ByteBuffer>)streamResponse);
        return new IterableStream(openAIServerSentEvents.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ThreadRun submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs, Boolean stream) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest requestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(stream);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ThreadRun)((BinaryData)this.submitToolOutputsToRunWithResponse(threadId, runId, request, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest requestObj = new SubmitToolOutputsToRunRequest(toolOutputs);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ThreadRun)((BinaryData)this.submitToolOutputsToRunWithResponse(threadId, runId, request, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listVectorStoresWithResponse(RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listVectorStoresWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreWithResponse(BinaryData vectorStoreOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createVectorStoreWithResponse(vectorStoreOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getVectorStoreWithResponse(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> modifyVectorStoreWithResponse(String vectorStoreId, BinaryData vectorStoreUpdateOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.modifyVectorStoreWithResponse(vectorStoreId, vectorStoreUpdateOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteVectorStoreWithResponse(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listVectorStoreFilesWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listVectorStoreFilesWithResponse(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreFileWithResponse(String vectorStoreId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createVectorStoreFileWithResponse(vectorStoreId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreFileWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteVectorStoreFileWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreFileBatchWithResponse(String vectorStoreId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createVectorStoreFileBatchWithResponse(vectorStoreId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> cancelVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.cancelVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listVectorStoreFileBatchFilesWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listVectorStoreFileBatchFilesWithResponse(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AssistantThread updateThread(String threadId, UpdateAssistantThreadOptions updateAssistantThreadOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (AssistantThread)((BinaryData)this.updateThreadWithResponse(threadId, BinaryData.fromObject((Object)updateAssistantThreadOptions), requestOptions).getValue()).toObject(AssistantThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage createMessage(String threadId, ThreadMessageOptions threadMessageOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadMessage)((BinaryData)this.createMessageWithResponse(threadId, BinaryData.fromObject((Object)threadMessageOptions), requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<VectorStore> listVectorStores(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfVectorStore vectorStoreList = (OpenAIPageableListOfVectorStore)((BinaryData)this.listVectorStoresWithResponse(requestOptions).getValue()).toObject(OpenAIPageableListOfVectorStore.class);
        return PageableListAccessHelper.create(vectorStoreList.getData(), vectorStoreList.getFirstId(), vectorStoreList.getLastId(), vectorStoreList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<VectorStore> listVectorStores() {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfVectorStore vectorStoreList = (OpenAIPageableListOfVectorStore)((BinaryData)this.listVectorStoresWithResponse(requestOptions).getValue()).toObject(OpenAIPageableListOfVectorStore.class);
        return PageableListAccessHelper.create(vectorStoreList.getData(), vectorStoreList.getFirstId(), vectorStoreList.getLastId(), vectorStoreList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore createVectorStore(VectorStoreOptions vectorStoreOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStore)((BinaryData)this.createVectorStoreWithResponse(BinaryData.fromObject((Object)vectorStoreOptions), requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore getVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStore)((BinaryData)this.getVectorStoreWithResponse(vectorStoreId, requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore modifyVectorStore(String vectorStoreId, VectorStoreUpdateOptions vectorStoreUpdateOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStore)((BinaryData)this.modifyVectorStoreWithResponse(vectorStoreId, BinaryData.fromObject((Object)vectorStoreUpdateOptions), requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreDeletionStatus deleteVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreDeletionStatus)((BinaryData)this.deleteVectorStoreWithResponse(vectorStoreId, requestOptions).getValue()).toObject(VectorStoreDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<VectorStoreFile> listVectorStoreFiles(String vectorStoreId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfVectorStoreFile vectorStoreFileList = (OpenAIPageableListOfVectorStoreFile)((BinaryData)this.listVectorStoreFilesWithResponse(vectorStoreId, requestOptions).getValue()).toObject(OpenAIPageableListOfVectorStoreFile.class);
        return PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<VectorStoreFile> listVectorStoreFiles(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfVectorStoreFile vectorStoreFileList = (OpenAIPageableListOfVectorStoreFile)((BinaryData)this.listVectorStoreFilesWithResponse(vectorStoreId, requestOptions).getValue()).toObject(OpenAIPageableListOfVectorStoreFile.class);
        return PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFile createVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest requestObj = new CreateVectorStoreFileRequest(fileId);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (VectorStoreFile)((BinaryData)this.createVectorStoreFileWithResponse(vectorStoreId, request, requestOptions).getValue()).toObject(VectorStoreFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFile getVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFile)((BinaryData)this.getVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions).getValue()).toObject(VectorStoreFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileDeletionStatus deleteVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFileDeletionStatus)((BinaryData)this.deleteVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions).getValue()).toObject(VectorStoreFileDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch createVectorStoreFileBatch(String vectorStoreId, List<String> fileIds) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest requestObj = new CreateVectorStoreFileBatchRequest(fileIds);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (VectorStoreFileBatch)((BinaryData)this.createVectorStoreFileBatchWithResponse(vectorStoreId, request, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch getVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFileBatch)((BinaryData)this.getVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch cancelVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFileBatch)((BinaryData)this.cancelVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<VectorStoreFile> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        OpenAIPageableListOfVectorStoreFile vectorStoreFileList = (OpenAIPageableListOfVectorStoreFile)((BinaryData)this.listVectorStoreFileBatchFilesWithResponse(vectorStoreId, batchId, requestOptions).getValue()).toObject(OpenAIPageableListOfVectorStoreFile.class);
        return PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<VectorStoreFile> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        OpenAIPageableListOfVectorStoreFile vectorStoreFileList = (OpenAIPageableListOfVectorStoreFile)((BinaryData)this.listVectorStoreFileBatchFilesWithResponse(vectorStoreId, batchId, requestOptions).getValue()).toObject(OpenAIPageableListOfVectorStoreFile.class);
        return PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore());
    }
}

