/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatOption;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.ai.openai.assistants.models.ToolResources;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

public final class Assistant
implements JsonSerializable<Assistant> {
    private final String id;
    private final String object = "assistant";
    private final long createdAt;
    private final String name;
    private final String description;
    private final String model;
    private final String instructions;
    private final List<ToolDefinition> tools;
    private final Map<String, String> metadata;
    private final ToolResources toolResources;
    private final Double temperature;
    private final Double topP;
    private BinaryData responseFormat;

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        if (this.responseFormat != null) {
            jsonWriter.writeUntypedField("response_format", this.responseFormat.toObject(Object.class));
        }
        return jsonWriter.writeEndObject();
    }

    public static Assistant fromJson(JsonReader jsonReader) throws IOException {
        return (Assistant)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String name = null;
            String description = null;
            String model = null;
            String instructions = null;
            List tools = null;
            ToolResources toolResources = null;
            Double temperature = null;
            Double topP = null;
            Map metadata = null;
            BinaryData responseFormat = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    toolResources = ToolResources.fromJson(reader);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            Assistant deserializedAssistant = new Assistant(id, createdAt, name, description, model, instructions, tools, toolResources, temperature, topP, metadata);
            deserializedAssistant.responseFormat = responseFormat;
            return deserializedAssistant;
        });
    }

    private Assistant(String id, OffsetDateTime createdAt, String name, String description, String model, String instructions, List<ToolDefinition> tools, ToolResources toolResources, Double temperature, Double topP, Map<String, String> metadata) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.name = name;
        this.description = description;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.temperature = temperature;
        this.topP = topP;
        this.metadata = metadata;
    }

    public ToolResources getToolResources() {
        return this.toolResources;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public AssistantsApiResponseFormatOption getResponseFormat() {
        return AssistantsApiResponseFormatOption.fromBinaryData(this.responseFormat);
    }
}

