/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatOption;
import com.azure.ai.openai.assistants.models.CreateToolResourcesOptions;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AssistantCreationOptions
implements JsonSerializable<AssistantCreationOptions> {
    private final String model;
    private String name;
    private String description;
    private String instructions;
    private List<ToolDefinition> tools;
    private CreateToolResourcesOptions toolResources;
    private Double temperature;
    private Double topP;
    private BinaryData responseFormat;
    private Map<String, String> metadata;

    public AssistantCreationOptions(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public AssistantCreationOptions setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AssistantCreationOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public AssistantCreationOptions setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public AssistantCreationOptions setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public CreateToolResourcesOptions getToolResources() {
        return this.toolResources;
    }

    public AssistantCreationOptions setToolResources(CreateToolResourcesOptions toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public AssistantCreationOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public AssistantCreationOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public AssistantsApiResponseFormatOption getResponseFormat() {
        return AssistantsApiResponseFormatOption.fromBinaryData(this.responseFormat);
    }

    public AssistantCreationOptions setResponseFormat(AssistantsApiResponseFormatOption responseFormat) {
        this.responseFormat = responseFormat.getFormat() != null ? BinaryData.fromObject((Object)responseFormat.getFormat()) : (responseFormat.getMode() != null ? BinaryData.fromObject((Object)((Object)responseFormat.getMode())) : null);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AssistantCreationOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        if (this.responseFormat != null) {
            jsonWriter.writeUntypedField("response_format", this.responseFormat.toObject(Object.class));
        }
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AssistantCreationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AssistantCreationOptions)jsonReader.readObject(reader -> {
            String model = null;
            String name = null;
            String description = null;
            String instructions = null;
            List tools = null;
            CreateToolResourcesOptions toolResources = null;
            Double temperature = null;
            Double topP = null;
            BinaryData responseFormat = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    toolResources = CreateToolResourcesOptions.fromJson(reader);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AssistantCreationOptions deserializedAssistantCreationOptions = new AssistantCreationOptions(model);
            deserializedAssistantCreationOptions.name = name;
            deserializedAssistantCreationOptions.description = description;
            deserializedAssistantCreationOptions.instructions = instructions;
            deserializedAssistantCreationOptions.tools = tools;
            deserializedAssistantCreationOptions.toolResources = toolResources;
            deserializedAssistantCreationOptions.temperature = temperature;
            deserializedAssistantCreationOptions.topP = topP;
            deserializedAssistantCreationOptions.responseFormat = responseFormat;
            deserializedAssistantCreationOptions.metadata = metadata;
            return deserializedAssistantCreationOptions;
        });
    }
}

