/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.CreateToolResourcesOptions;
import com.azure.ai.openai.assistants.models.ThreadMessageOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AssistantThreadCreationOptions
implements JsonSerializable<AssistantThreadCreationOptions> {
    private List<ThreadMessageOptions> messages;
    private Map<String, String> metadata;
    private CreateToolResourcesOptions toolResources;

    public List<ThreadMessageOptions> getMessages() {
        return this.messages;
    }

    public AssistantThreadCreationOptions setMessages(List<ThreadMessageOptions> messages) {
        this.messages = messages;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AssistantThreadCreationOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AssistantThreadCreationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AssistantThreadCreationOptions)jsonReader.readObject(reader -> {
            AssistantThreadCreationOptions deserializedAssistantThreadCreationOptions = new AssistantThreadCreationOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    List messages;
                    deserializedAssistantThreadCreationOptions.messages = messages = reader.readArray(reader1 -> ThreadMessageOptions.fromJson(reader1));
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    deserializedAssistantThreadCreationOptions.toolResources = CreateToolResourcesOptions.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAssistantThreadCreationOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAssistantThreadCreationOptions;
        });
    }

    public CreateToolResourcesOptions getToolResources() {
        return this.toolResources;
    }

    public AssistantThreadCreationOptions setToolResources(CreateToolResourcesOptions toolResources) {
        this.toolResources = toolResources;
        return this;
    }
}

