/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.CreateCodeInterpreterToolResourceOptions;
import com.azure.ai.openai.assistants.models.CreateFileSearchToolResourceOptions;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CreateToolResourcesOptions
implements JsonSerializable<CreateToolResourcesOptions> {
    private CreateCodeInterpreterToolResourceOptions codeInterpreter;
    private BinaryData fileSearch;

    public CreateCodeInterpreterToolResourceOptions getCodeInterpreter() {
        return this.codeInterpreter;
    }

    public CreateToolResourcesOptions setCodeInterpreter(CreateCodeInterpreterToolResourceOptions codeInterpreter) {
        this.codeInterpreter = codeInterpreter;
        return this;
    }

    public CreateFileSearchToolResourceOptions getFileSearch() {
        return CreateFileSearchToolResourceOptions.fromBinaryData(this.fileSearch);
    }

    public CreateToolResourcesOptions setFileSearch(CreateFileSearchToolResourceOptions fileSearch) {
        this.fileSearch = fileSearch.getVectorStoreIds() != null ? BinaryData.fromObject((Object)fileSearch.getVectorStoreIds()) : (fileSearch.getVectorStores() != null ? BinaryData.fromObject((Object)fileSearch.getVectorStores()) : null);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("code_interpreter", (JsonSerializable)this.codeInterpreter);
        if (this.fileSearch != null) {
            jsonWriter.writeUntypedField("file_search", this.fileSearch.toObject(Object.class));
        }
        return jsonWriter.writeEndObject();
    }

    public static CreateToolResourcesOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CreateToolResourcesOptions)jsonReader.readObject(reader -> {
            CreateToolResourcesOptions deserializedCreateToolResourcesOptions = new CreateToolResourcesOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code_interpreter".equals(fieldName)) {
                    deserializedCreateToolResourcesOptions.codeInterpreter = CreateCodeInterpreterToolResourceOptions.fromJson(reader);
                    continue;
                }
                if ("file_search".equals(fieldName)) {
                    deserializedCreateToolResourcesOptions.fileSearch = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateToolResourcesOptions;
        });
    }
}

