/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageDeltaImageFileContent;
import com.azure.ai.openai.assistants.models.MessageDeltaTextContentObject;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class MessageDeltaContent
implements JsonSerializable<MessageDeltaContent> {
    private String type = "MessageDeltaContent";
    private final int index;

    protected MessageDeltaContent(int index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaContent fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaContent)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MessageDeltaContent messageDeltaContent;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("image_file".equals(discriminatorValue)) {
                    messageDeltaContent = MessageDeltaImageFileContent.fromJson(readerToUse.reset());
                    return messageDeltaContent;
                }
                if ("text".equals(discriminatorValue)) {
                    messageDeltaContent = MessageDeltaTextContentObject.fromJson(readerToUse.reset());
                    return messageDeltaContent;
                }
                messageDeltaContent = MessageDeltaContent.fromJsonKnownDiscriminator(readerToUse.reset());
                return messageDeltaContent;
            }
        });
    }

    static MessageDeltaContent fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MessageDeltaContent)jsonReader.readObject(reader -> {
            int index = 0;
            String type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaContent deserializedMessageDeltaContent = new MessageDeltaContent(index);
            deserializedMessageDeltaContent.type = type;
            return deserializedMessageDeltaContent;
        });
    }
}

