/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RunStepFileSearchToolCall
extends RunStepToolCall {
    private String type = "file_search";
    private final Map<String, String> fileSearch;

    private RunStepFileSearchToolCall(String id, Map<String, String> fileSearch) {
        super(id);
        this.fileSearch = fileSearch;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Map<String, String> getFileSearch() {
        return this.fileSearch;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeMapField("file_search", this.fileSearch, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepFileSearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepFileSearchToolCall)jsonReader.readObject(reader -> {
            String id = null;
            Map fileSearch = null;
            String type = "file_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("file_search".equals(fieldName)) {
                    fileSearch = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepFileSearchToolCall deserializedRunStepFileSearchToolCall = new RunStepFileSearchToolCall(id, fileSearch);
            deserializedRunStepFileSearchToolCall.type = type;
            return deserializedRunStepFileSearchToolCall;
        });
    }
}

