/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatOption;
import com.azure.ai.openai.assistants.models.AssistantsApiToolChoiceOption;
import com.azure.ai.openai.assistants.models.IncompleteRunDetails;
import com.azure.ai.openai.assistants.models.RequiredAction;
import com.azure.ai.openai.assistants.models.RunCompletionUsage;
import com.azure.ai.openai.assistants.models.RunError;
import com.azure.ai.openai.assistants.models.RunStatus;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.ai.openai.assistants.models.TruncationObject;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

public final class ThreadRun
implements JsonSerializable<ThreadRun> {
    private final String id;
    private final String object = "thread.run";
    private final String threadId;
    private final String assistantId;
    private final RunStatus status;
    private RequiredAction requiredAction;
    private final RunError lastError;
    private final String model;
    private final String instructions;
    private final List<ToolDefinition> tools;
    private final long createdAt;
    private final Long expiresAt;
    private final Long startedAt;
    private final Long completedAt;
    private final Long cancelledAt;
    private final Long failedAt;
    private final Map<String, String> metadata;
    private final RunCompletionUsage usage;
    private final IncompleteRunDetails incompleteDetails;
    private Double temperature;
    private Double topP;
    private final Integer maxPromptTokens;
    private final Integer maxCompletionTokens;
    private final TruncationObject truncationStrategy;
    private final BinaryData toolChoice;
    private final BinaryData responseFormat;

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public RunStatus getStatus() {
        return this.status;
    }

    public RequiredAction getRequiredAction() {
        return this.requiredAction;
    }

    public RunError getLastError() {
        return this.lastError;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getExpiresAt() {
        if (this.expiresAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getStartedAt() {
        if (this.startedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.startedAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCancelledAt() {
        if (this.cancelledAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancelledAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getFailedAt() {
        if (this.failedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.failedAt), ZoneOffset.UTC);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("thread_id", this.threadId);
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("last_error", (JsonSerializable)this.lastError);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeNumberField("expires_at", (Number)this.expiresAt);
        jsonWriter.writeNumberField("started_at", (Number)this.startedAt);
        jsonWriter.writeNumberField("completed_at", (Number)this.completedAt);
        jsonWriter.writeNumberField("cancelled_at", (Number)this.cancelledAt);
        jsonWriter.writeNumberField("failed_at", (Number)this.failedAt);
        jsonWriter.writeStringField("incomplete_details", this.incompleteDetails == null ? null : this.incompleteDetails.toString());
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeNumberField("max_prompt_tokens", (Number)this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", (Number)this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", (JsonSerializable)this.truncationStrategy);
        jsonWriter.writeUntypedField("tool_choice", this.toolChoice.toObject(Object.class));
        jsonWriter.writeUntypedField("response_format", this.responseFormat.toObject(Object.class));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("required_action", (JsonSerializable)this.requiredAction);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        return jsonWriter.writeEndObject();
    }

    public static ThreadRun fromJson(JsonReader jsonReader) throws IOException {
        return (ThreadRun)jsonReader.readObject(reader -> {
            String id = null;
            String threadId = null;
            String assistantId = null;
            RunStatus status = null;
            RunError lastError = null;
            String model = null;
            String instructions = null;
            List tools = null;
            OffsetDateTime createdAt = null;
            OffsetDateTime expiresAt = null;
            OffsetDateTime startedAt = null;
            OffsetDateTime completedAt = null;
            OffsetDateTime cancelledAt = null;
            OffsetDateTime failedAt = null;
            IncompleteRunDetails incompleteDetails = null;
            RunCompletionUsage usage = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Map metadata = null;
            RequiredAction requiredAction = null;
            Double temperature = null;
            Double topP = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("thread_id".equals(fieldName)) {
                    threadId = reader.getString();
                    continue;
                }
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = RunStatus.fromString(reader.getString());
                    continue;
                }
                if ("last_error".equals(fieldName)) {
                    lastError = RunError.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("expires_at".equals(fieldName)) {
                    Long expiresAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (expiresAtHolder == null) continue;
                    expiresAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("started_at".equals(fieldName)) {
                    Long startedAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (startedAtHolder == null) continue;
                    startedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(startedAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("completed_at".equals(fieldName)) {
                    Long completedAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (completedAtHolder == null) continue;
                    completedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(completedAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("cancelled_at".equals(fieldName)) {
                    Long cancelledAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (cancelledAtHolder == null) continue;
                    cancelledAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(cancelledAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("failed_at".equals(fieldName)) {
                    Long failedAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (failedAtHolder == null) continue;
                    failedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(failedAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("incomplete_details".equals(fieldName)) {
                    incompleteDetails = IncompleteRunDetails.fromString(reader.getString());
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = RunCompletionUsage.fromJson(reader);
                    continue;
                }
                if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("required_action".equals(fieldName)) {
                    requiredAction = RequiredAction.fromJson(reader);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            ThreadRun deserializedThreadRun = new ThreadRun(id, threadId, assistantId, status, lastError, model, instructions, tools, createdAt, expiresAt, startedAt, completedAt, cancelledAt, failedAt, incompleteDetails, usage, maxPromptTokens, maxCompletionTokens, truncationStrategy, toolChoice, responseFormat, metadata);
            deserializedThreadRun.requiredAction = requiredAction;
            deserializedThreadRun.temperature = temperature;
            deserializedThreadRun.topP = topP;
            return deserializedThreadRun;
        });
    }

    public RunCompletionUsage getUsage() {
        return this.usage;
    }

    public IncompleteRunDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    private ThreadRun(String id, String threadId, String assistantId, RunStatus status, RunError lastError, String model, String instructions, List<ToolDefinition> tools, OffsetDateTime createdAt, OffsetDateTime expiresAt, OffsetDateTime startedAt, OffsetDateTime completedAt, OffsetDateTime cancelledAt, OffsetDateTime failedAt, IncompleteRunDetails incompleteDetails, RunCompletionUsage usage, Integer maxPromptTokens, Integer maxCompletionTokens, TruncationObject truncationStrategy, BinaryData toolChoice, BinaryData responseFormat, Map<String, String> metadata) {
        this.id = id;
        this.threadId = threadId;
        this.assistantId = assistantId;
        this.status = status;
        this.lastError = lastError;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.expiresAt = expiresAt == null ? null : Long.valueOf(expiresAt.toEpochSecond());
        this.startedAt = startedAt == null ? null : Long.valueOf(startedAt.toEpochSecond());
        this.completedAt = completedAt == null ? null : Long.valueOf(completedAt.toEpochSecond());
        this.cancelledAt = cancelledAt == null ? null : Long.valueOf(cancelledAt.toEpochSecond());
        this.failedAt = failedAt == null ? null : Long.valueOf(failedAt.toEpochSecond());
        this.incompleteDetails = incompleteDetails;
        this.usage = usage;
        this.maxPromptTokens = maxPromptTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.truncationStrategy = truncationStrategy;
        this.toolChoice = toolChoice;
        this.responseFormat = responseFormat;
        this.metadata = metadata;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public AssistantsApiToolChoiceOption getToolChoice() {
        return AssistantsApiToolChoiceOption.fromBinaryData(this.toolChoice);
    }

    public AssistantsApiResponseFormatOption getResponseFormat() {
        return AssistantsApiResponseFormatOption.fromBinaryData(this.responseFormat);
    }
}

