/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.CodeInterpreterToolResource;
import com.azure.ai.openai.assistants.models.FileSearchToolResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ToolResources
implements JsonSerializable<ToolResources> {
    private CodeInterpreterToolResource codeInterpreter;
    private FileSearchToolResource fileSearch;

    private ToolResources() {
    }

    public CodeInterpreterToolResource getCodeInterpreter() {
        return this.codeInterpreter;
    }

    public FileSearchToolResource getFileSearch() {
        return this.fileSearch;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("code_interpreter", (JsonSerializable)this.codeInterpreter);
        jsonWriter.writeJsonField("file_search", (JsonSerializable)this.fileSearch);
        return jsonWriter.writeEndObject();
    }

    public static ToolResources fromJson(JsonReader jsonReader) throws IOException {
        return (ToolResources)jsonReader.readObject(reader -> {
            ToolResources deserializedToolResources = new ToolResources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code_interpreter".equals(fieldName)) {
                    deserializedToolResources.codeInterpreter = CodeInterpreterToolResource.fromJson(reader);
                    continue;
                }
                if ("file_search".equals(fieldName)) {
                    deserializedToolResources.fileSearch = FileSearchToolResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedToolResources;
        });
    }
}

