/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreFileError;
import com.azure.ai.openai.assistants.models.VectorStoreFileStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class VectorStoreFile
implements JsonSerializable<VectorStoreFile> {
    private final String id;
    private final String object = "vector_store.file";
    private final int usageBytes;
    private final long createdAt;
    private final String vectorStoreId;
    private final VectorStoreFileStatus status;
    private final VectorStoreFileError lastError;

    private VectorStoreFile(String id, int usageBytes, OffsetDateTime createdAt, String vectorStoreId, VectorStoreFileStatus status, VectorStoreFileError lastError) {
        this.id = id;
        this.usageBytes = usageBytes;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.vectorStoreId = vectorStoreId;
        this.status = status;
        this.lastError = lastError;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public int getUsageBytes() {
        return this.usageBytes;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getVectorStoreId() {
        return this.vectorStoreId;
    }

    public VectorStoreFileStatus getStatus() {
        return this.status;
    }

    public VectorStoreFileError getLastError() {
        return this.lastError;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeIntField("usage_bytes", this.usageBytes);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("vector_store_id", this.vectorStoreId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("last_error", (JsonSerializable)this.lastError);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreFile fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreFile)jsonReader.readObject(reader -> {
            String id = null;
            int usageBytes = 0;
            OffsetDateTime createdAt = null;
            String vectorStoreId = null;
            VectorStoreFileStatus status = null;
            VectorStoreFileError lastError = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("usage_bytes".equals(fieldName)) {
                    usageBytes = reader.getInt();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("vector_store_id".equals(fieldName)) {
                    vectorStoreId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = VectorStoreFileStatus.fromString(reader.getString());
                    continue;
                }
                if ("last_error".equals(fieldName)) {
                    lastError = VectorStoreFileError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreFile(id, usageBytes, createdAt, vectorStoreId, status, lastError);
        });
    }
}

