/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreFileBatchStatus;
import com.azure.ai.openai.assistants.models.VectorStoreFileCount;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class VectorStoreFileBatch
implements JsonSerializable<VectorStoreFileBatch> {
    private final String id;
    private final String object = "vector_store.files_batch";
    private final long createdAt;
    private final String vectorStoreId;
    private final VectorStoreFileBatchStatus status;
    private final VectorStoreFileCount fileCounts;

    private VectorStoreFileBatch(String id, OffsetDateTime createdAt, String vectorStoreId, VectorStoreFileBatchStatus status, VectorStoreFileCount fileCounts) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.vectorStoreId = vectorStoreId;
        this.status = status;
        this.fileCounts = fileCounts;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getVectorStoreId() {
        return this.vectorStoreId;
    }

    public VectorStoreFileBatchStatus getStatus() {
        return this.status;
    }

    public VectorStoreFileCount getFileCounts() {
        return this.fileCounts;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("vector_store_id", this.vectorStoreId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("file_counts", (JsonSerializable)this.fileCounts);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreFileBatch fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreFileBatch)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String vectorStoreId = null;
            VectorStoreFileBatchStatus status = null;
            VectorStoreFileCount fileCounts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("vector_store_id".equals(fieldName)) {
                    vectorStoreId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = VectorStoreFileBatchStatus.fromString(reader.getString());
                    continue;
                }
                if ("file_counts".equals(fieldName)) {
                    fileCounts = VectorStoreFileCount.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreFileBatch(id, createdAt, vectorStoreId, status, fileCounts);
        });
    }
}

