/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreExpirationPolicy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class VectorStoreUpdateOptions
implements JsonSerializable<VectorStoreUpdateOptions> {
    private String name;
    private VectorStoreExpirationPolicy expiresAfter;
    private Map<String, String> metadata;

    public String getName() {
        return this.name;
    }

    public VectorStoreUpdateOptions setName(String name) {
        this.name = name;
        return this;
    }

    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    public VectorStoreUpdateOptions setExpiresAfter(VectorStoreExpirationPolicy expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public VectorStoreUpdateOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("expires_after", (JsonSerializable)this.expiresAfter);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreUpdateOptions fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreUpdateOptions)jsonReader.readObject(reader -> {
            VectorStoreUpdateOptions deserializedVectorStoreUpdateOptions = new VectorStoreUpdateOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVectorStoreUpdateOptions.name = reader.getString();
                    continue;
                }
                if ("expires_after".equals(fieldName)) {
                    deserializedVectorStoreUpdateOptions.expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedVectorStoreUpdateOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorStoreUpdateOptions;
        });
    }
}

