// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The representation of a single prompt completion as part of an overall chat completions request. Generally, `n`
 * choices are generated per provided prompt with a default value of 1. Token limits and other settings may limit the
 * number of choices generated.
 */
@Immutable
public final class ChatChoice {
    /*
     * The chat message for a given chat completions prompt.
     */
    @JsonProperty(value = "message")
    private ChatMessage message;

    /*
     * The ordered index associated with this chat completions choice.
     */
    @JsonProperty(value = "index", required = true)
    private int index;

    /*
     * The reason that this chat completions choice completed its generated.
     */
    @JsonProperty(value = "finish_reason", required = true)
    private CompletionsFinishReason finishReason;

    /*
     * The delta message content for a streaming response.
     */
    @JsonProperty(value = "delta")
    private ChatMessageDelta delta;

    /**
     * Creates an instance of ChatChoice class.
     *
     * @param index the index value to set.
     * @param finishReason the finishReason value to set.
     */
    @JsonCreator
    private ChatChoice(
            @JsonProperty(value = "index", required = true) int index,
            @JsonProperty(value = "finish_reason", required = true) CompletionsFinishReason finishReason) {
        this.index = index;
        this.finishReason = finishReason;
    }

    /**
     * Get the message property: The chat message for a given chat completions prompt.
     *
     * @return the message value.
     */
    public ChatMessage getMessage() {
        return this.message;
    }

    /**
     * Get the index property: The ordered index associated with this chat completions choice.
     *
     * @return the index value.
     */
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the finishReason property: The reason that this chat completions choice completed its generated.
     *
     * @return the finishReason value.
     */
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    /**
     * Get the delta property: The delta message content for a streaming response.
     *
     * @return the delta value.
     */
    public ChatMessageDelta getDelta() {
        return this.delta;
    }
}
