// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A single, role-attributed message within a chat completion interaction. */
@Fluent
public final class ChatMessage {
    /*
     * The role associated with this message payload.
     */
    @JsonProperty(value = "role", required = true)
    private ChatRole role;

    /*
     * The text associated with this message payload.
     */
    @JsonProperty(value = "content")
    private String content;

    /**
     * Creates an instance of ChatMessage class.
     *
     * @param role the role value to set.
     */
    @JsonCreator
    public ChatMessage(@JsonProperty(value = "role", required = true) ChatRole role) {
        this.role = role;
    }

    /**
     * Get the role property: The role associated with this message payload.
     *
     * @return the role value.
     */
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The text associated with this message payload.
     *
     * @return the content value.
     */
    public String getContent() {
        return this.content;
    }

    /**
     * Set the content property: The text associated with this message payload.
     *
     * @param content the content value to set.
     * @return the ChatMessage object itself.
     */
    public ChatMessage setContent(String content) {
        this.content = content;
        return this;
    }
}
