// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An incremental message delta within chat completion streaming. */
@Immutable
public final class ChatMessageDelta {
    /*
     * The role associated with this message payload.
     */
    @JsonProperty(value = "role")
    private ChatRole role;

    /*
     * The text associated with this message payload.
     */
    @JsonProperty(value = "content")
    private String content;

    /** Creates an instance of ChatMessageDelta class. */
    private ChatMessageDelta() {}

    /**
     * Get the role property: The role associated with this message payload.
     *
     * @return the role value.
     */
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The text associated with this message payload.
     *
     * @return the content value.
     */
    public String getContent() {
        return this.content;
    }
}
