// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The representation of a single prompt completion as part of an overall completions request. Generally, `n` choices
 * are generated per provided prompt with a default value of 1. Token limits and other settings may limit the number of
 * choices generated.
 */
@Immutable
public final class Choice {
    /*
     * The generated text for a given completions prompt.
     */
    @JsonProperty(value = "text", required = true)
    private String text;

    /*
     * The ordered index associated with this completions choice.
     */
    @JsonProperty(value = "index", required = true)
    private int index;

    /*
     * The log probabilities model for tokens associated with this completions choice.
     */
    @JsonProperty(value = "logprobs", required = true)
    private CompletionsLogProbabilityModel logprobs;

    /*
     * Reason for finishing
     */
    @JsonProperty(value = "finish_reason", required = true)
    private CompletionsFinishReason finishReason;

    /**
     * Creates an instance of Choice class.
     *
     * @param text the text value to set.
     * @param index the index value to set.
     * @param logprobs the logprobs value to set.
     * @param finishReason the finishReason value to set.
     */
    @JsonCreator
    private Choice(
            @JsonProperty(value = "text", required = true) String text,
            @JsonProperty(value = "index", required = true) int index,
            @JsonProperty(value = "logprobs", required = true) CompletionsLogProbabilityModel logprobs,
            @JsonProperty(value = "finish_reason", required = true) CompletionsFinishReason finishReason) {
        this.text = text;
        this.index = index;
        this.logprobs = logprobs;
        this.finishReason = finishReason;
    }

    /**
     * Get the text property: The generated text for a given completions prompt.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Get the index property: The ordered index associated with this completions choice.
     *
     * @return the index value.
     */
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the logprobs property: The log probabilities model for tokens associated with this completions choice.
     *
     * @return the logprobs value.
     */
    public CompletionsLogProbabilityModel getLogprobs() {
        return this.logprobs;
    }

    /**
     * Get the finishReason property: Reason for finishing.
     *
     * @return the finishReason value.
     */
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }
}
