// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Representation of the manner in which a completions response concluded. */
public final class CompletionsFinishReason extends ExpandableStringEnum<CompletionsFinishReason> {
    /** Completions ended normally and reached its end of token generation. */
    public static final CompletionsFinishReason STOPPED = fromString("stopped");

    /** Completions exhausted available token limits before generation could complete. */
    public static final CompletionsFinishReason TOKEN_LIMIT_REACHED = fromString("tokenLimitReached");

    /**
     * Completions generated a response that was identified as potentially sensitive per content moderation policies.
     */
    public static final CompletionsFinishReason CONTENT_FILTERED = fromString("contentFiltered");

    /**
     * Creates a new instance of CompletionsFinishReason value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CompletionsFinishReason() {}

    /**
     * Creates or finds a CompletionsFinishReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CompletionsFinishReason.
     */
    @JsonCreator
    public static CompletionsFinishReason fromString(String name) {
        return fromString(name, CompletionsFinishReason.class);
    }

    /**
     * Gets known CompletionsFinishReason values.
     *
     * @return known CompletionsFinishReason values.
     */
    public static Collection<CompletionsFinishReason> values() {
        return values(CompletionsFinishReason.class);
    }
}
