// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** LogProbs model within completion choice. */
@Immutable
public final class CompletionsLogProbs {
    /*
     * Tokens
     */
    @JsonProperty(value = "tokens")
    private List<String> tokens;

    /*
     * LogProbs of Tokens
     */
    @JsonProperty(value = "token_logprobs")
    private List<Double> tokenLogprobs;

    /*
     * Top LogProbs
     */
    @JsonProperty(value = "top_logprobs")
    private List<Map<String, Double>> topLogprobs;

    /*
     * Text offset
     */
    @JsonProperty(value = "text_offset")
    private List<Integer> textOffset;

    /** Creates an instance of CompletionsLogProbs class. */
    private CompletionsLogProbs() {}

    /**
     * Get the tokens property: Tokens.
     *
     * @return the tokens value.
     */
    public List<String> getTokens() {
        return this.tokens;
    }

    /**
     * Get the tokenLogprobs property: LogProbs of Tokens.
     *
     * @return the tokenLogprobs value.
     */
    public List<Double> getTokenLogprobs() {
        return this.tokenLogprobs;
    }

    /**
     * Get the topLogprobs property: Top LogProbs.
     *
     * @return the topLogprobs value.
     */
    public List<Map<String, Double>> getTopLogprobs() {
        return this.topLogprobs;
    }

    /**
     * Get the textOffset property: Text offset.
     *
     * @return the textOffset value.
     */
    public List<Integer> getTextOffset() {
        return this.textOffset;
    }
}
