// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Representation of a single embeddings relatedness comparison. */
@Immutable
public final class EmbeddingItem {
    /*
     * List of embeddings value for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input.
     */
    @JsonProperty(value = "embedding", required = true)
    private List<Double> embedding;

    /*
     * Index of the prompt to which the EmbeddingItem corresponds.
     */
    @JsonProperty(value = "index", required = true)
    private int index;

    /**
     * Creates an instance of EmbeddingItem class.
     *
     * @param embedding the embedding value to set.
     * @param index the index value to set.
     */
    @JsonCreator
    private EmbeddingItem(
            @JsonProperty(value = "embedding", required = true) List<Double> embedding,
            @JsonProperty(value = "index", required = true) int index) {
        this.embedding = embedding;
        this.index = index;
    }

    /**
     * Get the embedding property: List of embeddings value for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input.
     *
     * @return the embedding value.
     */
    public List<Double> getEmbedding() {
        return this.embedding;
    }

    /**
     * Get the index property: Index of the prompt to which the EmbeddingItem corresponds.
     *
     * @return the index value.
     */
    public int getIndex() {
        return this.index;
    }
}
