// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for the Azure Machine Learning vector index chat extension. The supported authentication types are
 * AccessToken, SystemAssignedManagedIdentity and UserAssignedManagedIdentity.
 */
@Fluent
public final class AzureMachineLearningIndexChatExtensionParameters
    implements JsonSerializable<AzureMachineLearningIndexChatExtensionParameters> {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    private String roleInformation;

    /*
     * The resource ID of the Azure Machine Learning project.
     */
    @Generated
    private final String projectResourceId;

    /*
     * The Azure Machine Learning vector index name.
     */
    @Generated
    private final String name;

    /*
     * The version of the Azure Machine Learning vector index.
     */
    @Generated
    private final String version;

    /*
     * Search filter. Only supported if the Azure Machine Learning vector index is of type AzureSearch.
     */
    @Generated
    private String filter;

    /**
     * Creates an instance of AzureMachineLearningIndexChatExtensionParameters class.
     *
     * @param projectResourceId the projectResourceId value to set.
     * @param name the name value to set.
     * @param version the version value to set.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters(String projectResourceId, String name, String version) {
        this.projectResourceId = projectResourceId;
        this.name = name;
        this.version = version;
    }

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters
        setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the projectResourceId property: The resource ID of the Azure Machine Learning project.
     *
     * @return the projectResourceId value.
     */
    @Generated
    public String getProjectResourceId() {
        return this.projectResourceId;
    }

    /**
     * Get the name property: The Azure Machine Learning vector index name.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the version property: The version of the Azure Machine Learning vector index.
     *
     * @return the version value.
     */
    @Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * Get the filter property: Search filter. Only supported if the Azure Machine Learning vector index is of type
     * AzureSearch.
     *
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: Search filter. Only supported if the Azure Machine Learning vector index is of type
     * AzureSearch.
     *
     * @param filter the filter value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("project_resource_id", this.projectResourceId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeJsonField("authentication", this.authentication);
        jsonWriter.writeNumberField("top_n_documents", this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", this.strictness);
        jsonWriter.writeStringField("role_information", this.roleInformation);
        jsonWriter.writeNumberField("max_search_queries", this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureMachineLearningIndexChatExtensionParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureMachineLearningIndexChatExtensionParameters if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureMachineLearningIndexChatExtensionParameters.
     */
    @Generated
    public static AzureMachineLearningIndexChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String projectResourceId = null;
            String name = null;
            String version = null;
            OnYourDataAuthenticationOptions authentication = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            String roleInformation = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List<OnYourDataContextProperty> includeContexts = null;
            String filter = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("project_resource_id".equals(fieldName)) {
                    projectResourceId = reader.getString();
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("version".equals(fieldName)) {
                    version = reader.getString();
                } else if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataAuthenticationOptions.fromJson(reader);
                } else if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = reader.getNullable(JsonReader::getInt);
                } else if ("in_scope".equals(fieldName)) {
                    inScope = reader.getNullable(JsonReader::getBoolean);
                } else if ("strictness".equals(fieldName)) {
                    strictness = reader.getNullable(JsonReader::getInt);
                } else if ("role_information".equals(fieldName)) {
                    roleInformation = reader.getString();
                } else if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = reader.getNullable(JsonReader::getInt);
                } else if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = reader.getNullable(JsonReader::getBoolean);
                } else if ("include_contexts".equals(fieldName)) {
                    includeContexts
                        = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                } else if ("filter".equals(fieldName)) {
                    filter = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            AzureMachineLearningIndexChatExtensionParameters deserializedAzureMachineLearningIndexChatExtensionParameters
                = new AzureMachineLearningIndexChatExtensionParameters(projectResourceId, name, version);
            deserializedAzureMachineLearningIndexChatExtensionParameters.authentication = authentication;
            deserializedAzureMachineLearningIndexChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedAzureMachineLearningIndexChatExtensionParameters.inScope = inScope;
            deserializedAzureMachineLearningIndexChatExtensionParameters.strictness = strictness;
            deserializedAzureMachineLearningIndexChatExtensionParameters.roleInformation = roleInformation;
            deserializedAzureMachineLearningIndexChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedAzureMachineLearningIndexChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedAzureMachineLearningIndexChatExtensionParameters.includeContexts = includeContexts;
            deserializedAzureMachineLearningIndexChatExtensionParameters.filter = filter;
            return deserializedAzureMachineLearningIndexChatExtensionParameters;
        });
    }

    /*
     * The max number of rewritten queries should be send to search provider for one user message. If not specified,
     * the system will decide the number of queries to send.
     */
    @Generated
    private Integer maxSearchQueries;

    /*
     * If specified as true, the system will allow partial search results to be used and the request fails if all the
     * queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     */
    @Generated
    private Boolean allowPartialResult;

    /*
     * The included properties of the output context. If not specified, the default value is `citations` and `intent`.
     */
    @Generated
    private List<OnYourDataContextProperty> includeContexts;

    /**
     * Get the maxSearchQueries property: The max number of rewritten queries should be send to search provider for one
     * user message. If not specified,
     * the system will decide the number of queries to send.
     *
     * @return the maxSearchQueries value.
     */
    @Generated
    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    /**
     * Set the maxSearchQueries property: The max number of rewritten queries should be send to search provider for one
     * user message. If not specified,
     * the system will decide the number of queries to send.
     *
     * @param maxSearchQueries the maxSearchQueries value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    /**
     * Get the allowPartialResult property: If specified as true, the system will allow partial search results to be
     * used and the request fails if all the queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     *
     * @return the allowPartialResult value.
     */
    @Generated
    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    /**
     * Set the allowPartialResult property: If specified as true, the system will allow partial search results to be
     * used and the request fails if all the queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     *
     * @param allowPartialResult the allowPartialResult value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    /**
     * Get the includeContexts property: The included properties of the output context. If not specified, the default
     * value is `citations` and `intent`.
     *
     * @return the includeContexts value.
     */
    @Generated
    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    /**
     * Set the includeContexts property: The included properties of the output context. If not specified, the default
     * value is `citations` and `intent`.
     *
     * @param includeContexts the includeContexts value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters
        setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }
}
