// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

/**
 * The result of a successful image generation operation.
 */
@Immutable
public final class ImageGenerations implements JsonSerializable<ImageGenerations> {

    /*
     * A timestamp representing when this operation was started.
     * Expressed in seconds since the Unix epoch of 1970-01-01T00:00:00+0000.
     */
    @Generated
    private final long createdAt;

    /*
     * The images generated by the operation.
     */
    @Generated
    private final List<ImageGenerationData> data;

    /**
     * Creates an instance of ImageGenerations class.
     *
     * @param createdAt the createdAt value to set.
     * @param data the data value to set.
     */
    @Generated
    private ImageGenerations(OffsetDateTime createdAt, List<ImageGenerationData> data) {
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.data = data;
    }

    /**
     * Get the createdAt property: A timestamp representing when this operation was started.
     * Expressed in seconds since the Unix epoch of 1970-01-01T00:00:00+0000.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the data property: The images generated by the operation.
     *
     * @return the data value.
     */
    @Generated
    public List<ImageGenerationData> getData() {
        return this.data;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("created", this.createdAt);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageGenerations from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageGenerations if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImageGenerations.
     */
    @Generated
    public static ImageGenerations fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OffsetDateTime createdAt = null;
            List<ImageGenerationData> data = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("created".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> ImageGenerationData.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new ImageGenerations(createdAt, data);
        });
    }
}
