/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.AzureMachineLearningIndexChatExtensionParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureMachineLearningIndexChatExtensionConfiguration
extends AzureChatExtensionConfiguration {
    private final AzureMachineLearningIndexChatExtensionParameters parameters;
    private AzureChatExtensionType type = AzureChatExtensionType.AZURE_MACHINE_LEARNING_INDEX;

    public AzureMachineLearningIndexChatExtensionParameters getParameters() {
        return this.parameters;
    }

    public AzureMachineLearningIndexChatExtensionConfiguration(AzureMachineLearningIndexChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureMachineLearningIndexChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMachineLearningIndexChatExtensionConfiguration)jsonReader.readObject(reader -> {
            AzureMachineLearningIndexChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.AZURE_MACHINE_LEARNING_INDEX;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = AzureMachineLearningIndexChatExtensionParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AzureMachineLearningIndexChatExtensionConfiguration deserializedAzureMachineLearningIndexChatExtensionConfiguration = new AzureMachineLearningIndexChatExtensionConfiguration(parameters);
            deserializedAzureMachineLearningIndexChatExtensionConfiguration.type = type;
            return deserializedAzureMachineLearningIndexChatExtensionConfiguration;
        });
    }
}

