/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatRequestAssistantMessage
extends ChatRequestMessage {
    private final String content;
    private String name;
    private List<ChatCompletionsToolCall> toolCalls;
    private FunctionCall functionCall;
    private ChatRole role = ChatRole.ASSISTANT;

    public ChatRequestAssistantMessage(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestAssistantMessage setName(String name) {
        this.name = name;
        return this;
    }

    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public ChatRequestAssistantMessage setToolCalls(List<ChatCompletionsToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public ChatRequestAssistantMessage setFunctionCall(FunctionCall functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("function_call", (JsonSerializable)this.functionCall);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestAssistantMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestAssistantMessage)jsonReader.readObject(reader -> {
            String content = null;
            ChatRole role = ChatRole.ASSISTANT;
            String name = null;
            List toolCalls = null;
            FunctionCall functionCall = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                    continue;
                }
                if ("function_call".equals(fieldName)) {
                    functionCall = FunctionCall.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestAssistantMessage deserializedChatRequestAssistantMessage = new ChatRequestAssistantMessage(content);
            deserializedChatRequestAssistantMessage.role = role;
            deserializedChatRequestAssistantMessage.name = name;
            deserializedChatRequestAssistantMessage.toolCalls = toolCalls;
            deserializedChatRequestAssistantMessage.functionCall = functionCall;
            return deserializedChatRequestAssistantMessage;
        });
    }
}

