// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration information for an embeddings request.
 * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
 * recommendations, and other similar scenarios.
 */
@Fluent
public final class EmbeddingsOptions implements JsonSerializable<EmbeddingsOptions> {

    /*
     * An identifier for the caller or end user of the operation. This may be used for tracking
     * or rate-limiting purposes.
     */
    @Generated
    private String user;

    /*
     * The model name to provide as part of this embeddings request.
     * Not applicable to Azure OpenAI, where deployment information should be included in the Azure
     * resource URI that's connected to.
     */
    @Generated
    private String model;

    /*
     * Input texts to get embeddings for, encoded as a an array of strings.
     * Each input must not exceed 2048 tokens in length.
     * 
     * Unless you are embedding code, we suggest replacing newlines (\n) in your input with a single space,
     * as we have observed inferior results when newlines are present.
     */
    @Generated
    private final List<String> input;

    /**
     * Creates an instance of EmbeddingsOptions class.
     *
     * @param input the input value to set.
     */
    @Generated
    public EmbeddingsOptions(List<String> input) {
        this.input = input;
    }

    /**
     * Get the user property: An identifier for the caller or end user of the operation. This may be used for tracking
     * or rate-limiting purposes.
     *
     * @return the user value.
     */
    @Generated
    public String getUser() {
        return this.user;
    }

    /**
     * Set the user property: An identifier for the caller or end user of the operation. This may be used for tracking
     * or rate-limiting purposes.
     *
     * @param user the user value to set.
     * @return the EmbeddingsOptions object itself.
     */
    @Generated
    public EmbeddingsOptions setUser(String user) {
        this.user = user;
        return this;
    }

    /**
     * Get the model property: The model name to provide as part of this embeddings request.
     * Not applicable to Azure OpenAI, where deployment information should be included in the Azure
     * resource URI that's connected to.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The model name to provide as part of this embeddings request.
     * Not applicable to Azure OpenAI, where deployment information should be included in the Azure
     * resource URI that's connected to.
     *
     * @param model the model value to set.
     * @return the EmbeddingsOptions object itself.
     */
    @Generated
    public EmbeddingsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the input property: Input texts to get embeddings for, encoded as a an array of strings.
     * Each input must not exceed 2048 tokens in length.
     *
     * Unless you are embedding code, we suggest replacing newlines (\n) in your input with a single space,
     * as we have observed inferior results when newlines are present.
     *
     * @return the input value.
     */
    @Generated
    public List<String> getInput() {
        return this.input;
    }

    /*
     * When using Azure OpenAI, specifies the input type to use for embedding search.
     */
    @Generated
    private String inputType;

    /**
     * Get the inputType property: When using Azure OpenAI, specifies the input type to use for embedding search.
     *
     * @return the inputType value.
     */
    @Generated
    public String getInputType() {
        return this.inputType;
    }

    /**
     * Set the inputType property: When using Azure OpenAI, specifies the input type to use for embedding search.
     *
     * @param inputType the inputType value to set.
     * @return the EmbeddingsOptions object itself.
     */
    @Generated
    public EmbeddingsOptions setInputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    /*
     * The number of dimensions the resulting output embeddings should have. Only supported in `text-embedding-3` and
     * later models.
     */
    @Generated
    private Integer dimensions;

    /**
     * Get the dimensions property: The number of dimensions the resulting output embeddings should have. Only supported
     * in `text-embedding-3` and later models.
     *
     * @return the dimensions value.
     */
    @Generated
    public Integer getDimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: The number of dimensions the resulting output embeddings should have. Only supported
     * in `text-embedding-3` and later models.
     *
     * @param dimensions the dimensions value to set.
     * @return the EmbeddingsOptions object itself.
     */
    @Generated
    public EmbeddingsOptions setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /*
     * The response encoding format to use for embedding data.
     */
    @Generated
    private EmbeddingEncodingFormat encodingFormat;

    /**
     * Get the encodingFormat property: The response encoding format to use for embedding data.
     *
     * @return the encodingFormat value.
     */
    @Generated
    EmbeddingEncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    /**
     * Set the encodingFormat property: The response encoding format to use for embedding data.
     *
     * @param encodingFormat the encodingFormat value to set.
     * @return the EmbeddingsOptions object itself.
     */
    @Generated
    EmbeddingsOptions setEncodingFormat(EmbeddingEncodingFormat encodingFormat) {
        this.encodingFormat = encodingFormat;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("input", this.input, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("encoding_format",
            this.encodingFormat == null ? null : this.encodingFormat.toString());
        jsonWriter.writeNumberField("dimensions", this.dimensions);
        jsonWriter.writeStringField("input_type", this.inputType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmbeddingsOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmbeddingsOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmbeddingsOptions.
     */
    @Generated
    public static EmbeddingsOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> input = null;
            String user = null;
            String model = null;
            EmbeddingEncodingFormat encodingFormat = null;
            Integer dimensions = null;
            String inputType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.readArray(reader1 -> reader1.getString());
                } else if ("user".equals(fieldName)) {
                    user = reader.getString();
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("encoding_format".equals(fieldName)) {
                    encodingFormat = EmbeddingEncodingFormat.fromString(reader.getString());
                } else if ("dimensions".equals(fieldName)) {
                    dimensions = reader.getNullable(JsonReader::getInt);
                } else if ("input_type".equals(fieldName)) {
                    inputType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            EmbeddingsOptions deserializedEmbeddingsOptions = new EmbeddingsOptions(input);
            deserializedEmbeddingsOptions.user = user;
            deserializedEmbeddingsOptions.model = model;
            deserializedEmbeddingsOptions.encodingFormat = encodingFormat;
            deserializedEmbeddingsOptions.dimensions = dimensions;
            deserializedEmbeddingsOptions.inputType = inputType;
            return deserializedEmbeddingsOptions;
        });
    }
}
