// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents the available sources Azure OpenAI On Your Data can use to configure vectorization of data for use with
 * vector search.
 */
public final class OnYourDataVectorizationSourceType extends ExpandableStringEnum<OnYourDataVectorizationSourceType> {

    /**
     * Represents vectorization performed by public service calls to an Azure OpenAI embedding model.
     */
    @Generated
    public static final OnYourDataVectorizationSourceType ENDPOINT = fromString("endpoint");

    /**
     * Represents an Ada model deployment name to use. This model deployment must be in the same Azure OpenAI resource,
     * but
     * On Your Data will use this model deployment via an internal call rather than a public one, which enables vector
     * search even in private networks.
     */
    @Generated
    public static final OnYourDataVectorizationSourceType DEPLOYMENT_NAME = fromString("deployment_name");

    /**
     * Represents a specific embedding model ID as defined in the search service.
     * Currently only supported by Elasticsearch®.
     */
    @Generated
    public static final OnYourDataVectorizationSourceType MODEL_ID = fromString("model_id");

    /**
     * Creates a new instance of OnYourDataVectorizationSourceType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public OnYourDataVectorizationSourceType() {
    }

    /**
     * Creates or finds a OnYourDataVectorizationSourceType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OnYourDataVectorizationSourceType.
     */
    @Generated
    public static OnYourDataVectorizationSourceType fromString(String name) {
        return fromString(name, OnYourDataVectorizationSourceType.class);
    }

    /**
     * Gets known OnYourDataVectorizationSourceType values.
     *
     * @return known OnYourDataVectorizationSourceType values.
     */
    @Generated
    public static Collection<OnYourDataVectorizationSourceType> values() {
        return values(OnYourDataVectorizationSourceType.class);
    }
}
