/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.implementation.EmbeddingsUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EmbeddingItem
implements JsonSerializable<EmbeddingItem> {
    private final int promptIndex;
    private List<Double> embedding;
    private List<Float> embeddingInFloat;
    private String embeddingBase64;

    public List<Float> getEmbedding() {
        if (this.embeddingInFloat == null && this.embeddingBase64 != null) {
            this.embeddingInFloat = EmbeddingsUtils.convertBase64ToFloatList(this.embeddingBase64);
        }
        return this.embeddingInFloat;
    }

    public String getEmbeddingAsString() {
        if (this.embeddingBase64 == null && this.embeddingInFloat != null) {
            this.embeddingBase64 = EmbeddingsUtils.convertFloatListToBase64(this.embeddingInFloat);
        }
        return this.embeddingBase64;
    }

    public int getPromptIndex() {
        return this.promptIndex;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.promptIndex);
        if (this.embeddingBase64 != null) {
            jsonWriter.writeStringField("embedding", this.embeddingBase64);
        } else if (this.embeddingInFloat != null) {
            jsonWriter.writeArrayField("embedding", this.embeddingInFloat, JsonWriter::writeFloat);
        }
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingItem fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingItem)jsonReader.readObject(reader -> {
            String embedding = null;
            List embeddingInFloat = null;
            int promptIndex = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("embedding".equals(fieldName)) {
                    JsonToken jsonToken = reader.currentToken();
                    if (jsonToken == JsonToken.STRING) {
                        embedding = reader.getString();
                        continue;
                    }
                    if (jsonToken == JsonToken.START_ARRAY) {
                        embeddingInFloat = reader.readArray(JsonReader::getFloat);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'embedding' type found when deserializing EmbeddingItem JSON object: " + jsonToken);
                }
                if ("index".equals(fieldName)) {
                    promptIndex = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            EmbeddingItem embeddingItem = new EmbeddingItem(embedding, promptIndex);
            embeddingItem.embeddingInFloat = embeddingInFloat;
            return embeddingItem;
        });
    }

    private EmbeddingItem(String embeddingBase64, int promptIndex) {
        this.embeddingBase64 = embeddingBase64;
        this.promptIndex = promptIndex;
    }
}

