// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A Datum containing information about a Batch Error.
 */
@Immutable
public final class BatchErrorDatum implements JsonSerializable<BatchErrorDatum> {

    /*
     * An error code identifying the error type.
     */
    @Generated
    private String code;

    /*
     * A human-readable message providing more details about the error.
     */
    @Generated
    private String message;

    /*
     * The name of the parameter that caused the error, if applicable.
     */
    @Generated
    private String param;

    /*
     * The line number of the input file where the error occurred, if applicable.
     */
    @Generated
    private Integer line;

    /**
     * Creates an instance of BatchErrorDatum class.
     */
    @Generated
    private BatchErrorDatum() {
    }

    /**
     * Get the code property: An error code identifying the error type.
     *
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable message providing more details about the error.
     *
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the param property: The name of the parameter that caused the error, if applicable.
     *
     * @return the param value.
     */
    @Generated
    public String getParam() {
        return this.param;
    }

    /**
     * Get the line property: The line number of the input file where the error occurred, if applicable.
     *
     * @return the line value.
     */
    @Generated
    public Integer getLine() {
        return this.line;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("param", this.param);
        jsonWriter.writeNumberField("line", this.line);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchErrorDatum from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchErrorDatum if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BatchErrorDatum.
     */
    @Generated
    public static BatchErrorDatum fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BatchErrorDatum deserializedBatchErrorDatum = new BatchErrorDatum();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedBatchErrorDatum.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedBatchErrorDatum.message = reader.getString();
                } else if ("param".equals(fieldName)) {
                    deserializedBatchErrorDatum.param = reader.getString();
                } else if ("line".equals(fieldName)) {
                    deserializedBatchErrorDatum.line = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedBatchErrorDatum;
        });
    }
}
