// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A structured chat content item containing model refusal information for a structured outputs request.
 */
@Immutable
public final class ChatMessageRefusalContentItem extends ChatMessageContentItem {

    /*
     * The discriminated object type.
     */
    @Generated
    private String type = "refusal";

    /*
     * The refusal message.
     */
    @Generated
    private final String refusal;

    /**
     * Creates an instance of ChatMessageRefusalContentItem class.
     *
     * @param refusal the refusal value to set.
     */
    @Generated
    public ChatMessageRefusalContentItem(String refusal) {
        this.refusal = refusal;
    }

    /**
     * Get the type property: The discriminated object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the refusal property: The refusal message.
     *
     * @return the refusal value.
     */
    @Generated
    public String getRefusal() {
        return this.refusal;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("refusal", this.refusal);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatMessageRefusalContentItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatMessageRefusalContentItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatMessageRefusalContentItem.
     */
    @Generated
    public static ChatMessageRefusalContentItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String refusal = null;
            String type = "refusal";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("refusal".equals(fieldName)) {
                    refusal = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatMessageRefusalContentItem deserializedChatMessageRefusalContentItem
                = new ChatMessageRefusalContentItem(refusal);
            deserializedChatMessageRefusalContentItem.type = type;
            return deserializedChatMessageRefusalContentItem;
        });
    }
}
