// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A representation of a chat message as received in a response.
 */
@Immutable
public final class ChatResponseMessage implements JsonSerializable<ChatResponseMessage> {

    /*
     * The chat role associated with the message.
     */
    @Generated
    private final ChatRole role;

    /*
     * The content of the message.
     */
    @Generated
    private final String content;

    /*
     * The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    private List<ChatCompletionsToolCall> toolCalls;

    /*
     * The function call that must be resolved and have its output appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    private FunctionCall functionCall;

    /*
     * If Azure OpenAI chat extensions are configured, this array represents the incremental steps performed by those
     * extensions while processing the chat completions request.
     */
    @Generated
    private AzureChatExtensionsMessageContext context;

    /**
     * Get the role property: The chat role associated with the message.
     *
     * @return the role value.
     */
    @Generated
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * Get the functionCall property: The function call that must be resolved and have its output appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the functionCall value.
     */
    @Generated
    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    /**
     * Get the context property: If Azure OpenAI chat extensions are configured, this array represents the incremental
     * steps performed by those
     * extensions while processing the chat completions request.
     *
     * @return the context value.
     */
    @Generated
    public AzureChatExtensionsMessageContext getContext() {
        return this.context;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("refusal", this.refusal);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("function_call", this.functionCall);
        jsonWriter.writeJsonField("context", this.context);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatResponseMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatResponseMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatResponseMessage.
     */
    @Generated
    public static ChatResponseMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatRole role = null;
            String refusal = null;
            String content = null;
            List<ChatCompletionsToolCall> toolCalls = null;
            FunctionCall functionCall = null;
            AzureChatExtensionsMessageContext context = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else if ("refusal".equals(fieldName)) {
                    refusal = reader.getString();
                } else if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                } else if ("function_call".equals(fieldName)) {
                    functionCall = FunctionCall.fromJson(reader);
                } else if ("context".equals(fieldName)) {
                    context = AzureChatExtensionsMessageContext.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            ChatResponseMessage deserializedChatResponseMessage = new ChatResponseMessage(role, refusal, content);
            deserializedChatResponseMessage.toolCalls = toolCalls;
            deserializedChatResponseMessage.functionCall = functionCall;
            deserializedChatResponseMessage.context = context;
            return deserializedChatResponseMessage;
        });
    }

    /*
     * The refusal message generated by the model.
     */
    @Generated
    private final String refusal;

    /**
     * Creates an instance of ChatResponseMessage class.
     *
     * @param role the role value to set.
     * @param refusal the refusal value to set.
     * @param content the content value to set.
     */
    @Generated
    private ChatResponseMessage(ChatRole role, String refusal, String content) {
        this.role = role;
        this.refusal = refusal;
        this.content = content;
    }

    /**
     * Get the refusal property: The refusal message generated by the model.
     *
     * @return the refusal value.
     */
    @Generated
    public String getRefusal() {
        return this.refusal;
    }
}
