// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request body of an upload creation operation.
 */
@Immutable
public final class CreateUploadRequest implements JsonSerializable<CreateUploadRequest> {

    /*
     * The name of the file to upload.
     */
    @Generated
    private final String filename;

    /*
     * The intended purpose of the uploaded file.
     * 
     * Use 'assistants' for Assistants and Message files, 'vision' for Assistants image file inputs, 'batch' for Batch
     * API, and 'fine-tune' for Fine-tuning.
     */
    @Generated
    private final CreateUploadRequestPurpose purpose;

    /*
     * The number of bytes in the file you are uploading.
     */
    @Generated
    private final int bytes;

    /*
     * The MIME type of the file.
     * 
     * This must fall within the supported MIME types for your file purpose. See the supported MIME types for assistants
     * and vision.
     */
    @Generated
    private final String mimeType;

    /**
     * Creates an instance of CreateUploadRequest class.
     *
     * @param filename the filename value to set.
     * @param purpose the purpose value to set.
     * @param bytes the bytes value to set.
     * @param mimeType the mimeType value to set.
     */
    @Generated
    public CreateUploadRequest(String filename, CreateUploadRequestPurpose purpose, int bytes, String mimeType) {
        this.filename = filename;
        this.purpose = purpose;
        this.bytes = bytes;
        this.mimeType = mimeType;
    }

    /**
     * Get the filename property: The name of the file to upload.
     *
     * @return the filename value.
     */
    @Generated
    public String getFilename() {
        return this.filename;
    }

    /**
     * Get the purpose property: The intended purpose of the uploaded file.
     *
     * Use 'assistants' for Assistants and Message files, 'vision' for Assistants image file inputs, 'batch' for Batch
     * API, and 'fine-tune' for Fine-tuning.
     *
     * @return the purpose value.
     */
    @Generated
    public CreateUploadRequestPurpose getPurpose() {
        return this.purpose;
    }

    /**
     * Get the bytes property: The number of bytes in the file you are uploading.
     *
     * @return the bytes value.
     */
    @Generated
    public int getBytes() {
        return this.bytes;
    }

    /**
     * Get the mimeType property: The MIME type of the file.
     *
     * This must fall within the supported MIME types for your file purpose. See the supported MIME types for assistants
     * and vision.
     *
     * @return the mimeType value.
     */
    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeStringField("purpose", this.purpose == null ? null : this.purpose.toString());
        jsonWriter.writeIntField("bytes", this.bytes);
        jsonWriter.writeStringField("mime_type", this.mimeType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreateUploadRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreateUploadRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CreateUploadRequest.
     */
    @Generated
    public static CreateUploadRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String filename = null;
            CreateUploadRequestPurpose purpose = null;
            int bytes = 0;
            String mimeType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filename".equals(fieldName)) {
                    filename = reader.getString();
                } else if ("purpose".equals(fieldName)) {
                    purpose = CreateUploadRequestPurpose.fromString(reader.getString());
                } else if ("bytes".equals(fieldName)) {
                    bytes = reader.getInt();
                } else if ("mime_type".equals(fieldName)) {
                    mimeType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new CreateUploadRequest(filename, purpose, bytes, mimeType);
        });
    }
}
