// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the content filtering results for the prompt of a image generation request.
 */
@Immutable
public final class ImageGenerationPromptFilterResults implements JsonSerializable<ImageGenerationPromptFilterResults> {

    /*
     * Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     */
    @Generated
    private ContentFilterResult sexual;

    /*
     * Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     */
    @Generated
    private ContentFilterResult violence;

    /*
     * Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     */
    @Generated
    private ContentFilterResult hate;

    /*
     * Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     */
    @Generated
    private ContentFilterResult selfHarm;

    /*
     * Describes whether profanity was detected.
     */
    @Generated
    private ContentFilterDetectionResult profanity;

    /*
     * Whether a jailbreak attempt was detected in the prompt.
     */
    @Generated
    private ContentFilterDetectionResult jailbreak;

    /**
     * Creates an instance of ImageGenerationPromptFilterResults class.
     */
    @Generated
    private ImageGenerationPromptFilterResults() {
    }

    /**
     * Get the sexual property: Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     *
     * @return the sexual value.
     */
    @Generated
    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    /**
     * Get the violence property: Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     *
     * @return the violence value.
     */
    @Generated
    public ContentFilterResult getViolence() {
        return this.violence;
    }

    /**
     * Get the hate property: Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     *
     * @return the hate value.
     */
    @Generated
    public ContentFilterResult getHate() {
        return this.hate;
    }

    /**
     * Get the selfHarm property: Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     *
     * @return the selfHarm value.
     */
    @Generated
    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    /**
     * Get the profanity property: Describes whether profanity was detected.
     *
     * @return the profanity value.
     */
    @Generated
    public ContentFilterDetectionResult getProfanity() {
        return this.profanity;
    }

    /**
     * Get the jailbreak property: Whether a jailbreak attempt was detected in the prompt.
     *
     * @return the jailbreak value.
     */
    @Generated
    public ContentFilterDetectionResult getJailbreak() {
        return this.jailbreak;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", this.sexual);
        jsonWriter.writeJsonField("violence", this.violence);
        jsonWriter.writeJsonField("hate", this.hate);
        jsonWriter.writeJsonField("self_harm", this.selfHarm);
        jsonWriter.writeJsonField("profanity", this.profanity);
        jsonWriter.writeJsonField("jailbreak", this.jailbreak);
        jsonWriter.writeJsonField("custom_blocklists", this.customBlocklists);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageGenerationPromptFilterResults from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageGenerationPromptFilterResults if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImageGenerationPromptFilterResults.
     */
    @Generated
    public static ImageGenerationPromptFilterResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageGenerationPromptFilterResults deserializedImageGenerationPromptFilterResults
                = new ImageGenerationPromptFilterResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.sexual = ContentFilterResult.fromJson(reader);
                } else if ("violence".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.violence = ContentFilterResult.fromJson(reader);
                } else if ("hate".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.hate = ContentFilterResult.fromJson(reader);
                } else if ("self_harm".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.selfHarm = ContentFilterResult.fromJson(reader);
                } else if ("profanity".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.profanity
                        = ContentFilterDetectionResult.fromJson(reader);
                } else if ("jailbreak".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.jailbreak
                        = ContentFilterDetectionResult.fromJson(reader);
                } else if ("custom_blocklists".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.customBlocklists
                        = ContentFilterDetailedResults.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedImageGenerationPromptFilterResults;
        });
    }

    /*
     * Information about customer block lists and if something was detected the associated list ID.
     */
    @Generated
    private ContentFilterDetailedResults customBlocklists;

    /**
     * Get the customBlocklists property: Information about customer block lists and if something was detected the
     * associated list ID.
     *
     * @return the customBlocklists value.
     */
    @Generated
    public ContentFilterDetailedResults getCustomBlocklists() {
        return this.customBlocklists;
    }
}
