// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An abstract representation of a vectorization source for Azure OpenAI On Your Data with vector search.
 */
@Immutable
public class OnYourDataVectorizationSource implements JsonSerializable<OnYourDataVectorizationSource> {

    /**
     * Creates an instance of OnYourDataVectorizationSource class.
     */
    @Generated
    public OnYourDataVectorizationSource() {
    }

    /*
     * The type of vectorization source to use.
     */
    @Generated
    private OnYourDataVectorizationSourceType type
        = OnYourDataVectorizationSourceType.fromString("OnYourDataVectorizationSource");

    /**
     * Get the type property: The type of vectorization source to use.
     *
     * @return the type value.
     */
    @Generated
    public OnYourDataVectorizationSourceType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataVectorizationSource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataVectorizationSource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OnYourDataVectorizationSource.
     */
    @Generated
    public static OnYourDataVectorizationSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("endpoint".equals(discriminatorValue)) {
                    return OnYourDataEndpointVectorizationSource.fromJson(readerToUse.reset());
                } else if ("deployment_name".equals(discriminatorValue)) {
                    return OnYourDataDeploymentNameVectorizationSource.fromJson(readerToUse.reset());
                } else if ("model_id".equals(discriminatorValue)) {
                    return OnYourDataModelIdVectorizationSource.fromJson(readerToUse.reset());
                } else if ("integrated".equals(discriminatorValue)) {
                    return OnYourDataIntegratedVectorizationSource.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static OnYourDataVectorizationSource fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OnYourDataVectorizationSource deserializedOnYourDataVectorizationSource
                = new OnYourDataVectorizationSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedOnYourDataVectorizationSource.type
                        = OnYourDataVectorizationSourceType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedOnYourDataVectorizationSource;
        });
    }
}
