// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/**
 * The upload Part represents a chunk of bytes we can add to an Upload object.
 */
@Immutable
public final class UploadPart implements JsonSerializable<UploadPart> {

    /*
     * The upload Part unique identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The Unix timestamp (in seconds) for when the Part was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The ID of the Upload object that this Part was added to.
     */
    @Generated
    private final String uploadId;

    /*
     * The object type, which is always `upload.part`.
     */
    @Generated
    private final String object = "upload.part";

    /**
     * Creates an instance of UploadPart class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param uploadId the uploadId value to set.
     */
    @Generated
    private UploadPart(String id, OffsetDateTime createdAt, String uploadId) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.uploadId = uploadId;
    }

    /**
     * Get the id property: The upload Part unique identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the createdAt property: The Unix timestamp (in seconds) for when the Part was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the uploadId property: The ID of the Upload object that this Part was added to.
     *
     * @return the uploadId value.
     */
    @Generated
    public String getUploadId() {
        return this.uploadId;
    }

    /**
     * Get the object property: The object type, which is always `upload.part`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("upload_id", this.uploadId);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("azure_block_id", this.azureBlockId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UploadPart from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of UploadPart if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UploadPart.
     */
    @Generated
    public static UploadPart fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String uploadId = null;
            String azureBlockId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("upload_id".equals(fieldName)) {
                    uploadId = reader.getString();
                } else if ("azure_block_id".equals(fieldName)) {
                    azureBlockId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            UploadPart deserializedUploadPart = new UploadPart(id, createdAt, uploadId);
            deserializedUploadPart.azureBlockId = azureBlockId;
            return deserializedUploadPart;
        });
    }

    /*
     * Azure only field.
     */
    @Generated
    private String azureBlockId;

    /**
     * Get the azureBlockId property: Azure only field.
     *
     * @return the azureBlockId value.
     */
    @Generated
    public String getAzureBlockId() {
        return this.azureBlockId;
    }
}
