// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The status of a batch.
 */
public final class BatchStatus extends ExpandableStringEnum<BatchStatus> {

    /**
     * The input file is being validated before the batch can begin.
     */
    @Generated
    public static final BatchStatus VALIDATING = fromString("validating");

    /**
     * The input file has failed the validation process.
     */
    @Generated
    public static final BatchStatus FAILED = fromString("failed");

    /**
     * The input file was successfully validated and the batch is currently being executed.
     */
    @Generated
    public static final BatchStatus IN_PROGRESS = fromString("in_progress");

    /**
     * The batch has completed and the results are being prepared.
     */
    @Generated
    public static final BatchStatus FINALIZING = fromString("finalizing");

    /**
     * The batch has been completed and the results are ready.
     */
    @Generated
    public static final BatchStatus COMPLETED = fromString("completed");

    /**
     * The batch was not able to complete within the 24-hour time window.
     */
    @Generated
    public static final BatchStatus EXPIRED = fromString("expired");

    /**
     * Cancellation of the batch has been initiated.
     */
    @Generated
    public static final BatchStatus CANCELLING = fromString("cancelling");

    /**
     * The batch was cancelled.
     */
    @Generated
    public static final BatchStatus CANCELLED = fromString("cancelled");

    /**
     * Creates a new instance of BatchStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public BatchStatus() {
    }

    /**
     * Creates or finds a BatchStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BatchStatus.
     */
    @Generated
    public static BatchStatus fromString(String name) {
        return fromString(name, BatchStatus.class);
    }

    /**
     * Gets known BatchStatus values.
     *
     * @return known BatchStatus values.
     */
    @Generated
    public static Collection<BatchStatus> values() {
        return values(BatchStatus.class);
    }
}
