// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Options for streaming response. Only set this when you set `stream: true`.
 */
@Fluent
public final class ChatCompletionStreamOptions implements JsonSerializable<ChatCompletionStreamOptions> {

    /*
     * If set, an additional chunk will be streamed before the `data: [DONE]` message. The `usage` field on this chunk
     * shows the token usage statistics for the entire request, and the `choices` field will always be an empty array.
     * All other chunks will also include a `usage` field, but with a null value.
     */
    @Generated
    private Boolean includeUsage;

    /**
     * Creates an instance of ChatCompletionStreamOptions class.
     */
    @Generated
    public ChatCompletionStreamOptions() {
    }

    /**
     * Get the includeUsage property: If set, an additional chunk will be streamed before the `data: [DONE]` message.
     * The `usage` field on this chunk shows the token usage statistics for the entire request, and the `choices` field
     * will always be an empty array. All other chunks will also include a `usage` field, but with a null value.
     *
     * @return the includeUsage value.
     */
    @Generated
    public Boolean isIncludeUsage() {
        return this.includeUsage;
    }

    /**
     * Set the includeUsage property: If set, an additional chunk will be streamed before the `data: [DONE]` message.
     * The `usage` field on this chunk shows the token usage statistics for the entire request, and the `choices` field
     * will always be an empty array. All other chunks will also include a `usage` field, but with a null value.
     *
     * @param includeUsage the includeUsage value to set.
     * @return the ChatCompletionStreamOptions object itself.
     */
    @Generated
    public ChatCompletionStreamOptions setIncludeUsage(Boolean includeUsage) {
        this.includeUsage = includeUsage;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("include_usage", this.includeUsage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionStreamOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionStreamOptions if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionStreamOptions.
     */
    @Generated
    public static ChatCompletionStreamOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionStreamOptions deserializedChatCompletionStreamOptions = new ChatCompletionStreamOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("include_usage".equals(fieldName)) {
                    deserializedChatCompletionStreamOptions.includeUsage = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatCompletionStreamOptions;
        });
    }
}
