// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The request body of an upload completion request.
 */
@Fluent
public final class CompleteUploadRequest implements JsonSerializable<CompleteUploadRequest> {

    /*
     * The ordered list of Part IDs.
     */
    @Generated
    private final List<String> partIds;

    /*
     * The optional md5 checksum for the file contents to verify if the bytes uploaded matches what you expect.
     */
    @Generated
    private String md5;

    /**
     * Creates an instance of CompleteUploadRequest class.
     *
     * @param partIds the partIds value to set.
     */
    @Generated
    public CompleteUploadRequest(List<String> partIds) {
        this.partIds = partIds;
    }

    /**
     * Get the partIds property: The ordered list of Part IDs.
     *
     * @return the partIds value.
     */
    @Generated
    public List<String> getPartIds() {
        return this.partIds;
    }

    /**
     * Get the md5 property: The optional md5 checksum for the file contents to verify if the bytes uploaded matches
     * what you expect.
     *
     * @return the md5 value.
     */
    @Generated
    public String getMd5() {
        return this.md5;
    }

    /**
     * Set the md5 property: The optional md5 checksum for the file contents to verify if the bytes uploaded matches
     * what you expect.
     *
     * @param md5 the md5 value to set.
     * @return the CompleteUploadRequest object itself.
     */
    @Generated
    public CompleteUploadRequest setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("part_ids", this.partIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("md5", this.md5);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CompleteUploadRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CompleteUploadRequest if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CompleteUploadRequest.
     */
    @Generated
    public static CompleteUploadRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> partIds = null;
            String md5 = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("part_ids".equals(fieldName)) {
                    partIds = reader.readArray(reader1 -> reader1.getString());
                } else if ("md5".equals(fieldName)) {
                    md5 = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            CompleteUploadRequest deserializedCompleteUploadRequest = new CompleteUploadRequest(partIds);
            deserializedCompleteUploadRequest.md5 = md5;
            return deserializedCompleteUploadRequest;
        });
    }
}
