// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the content filtering result for the image generation request.
 */
@Immutable
public final class ImageGenerationContentFilterResults
    implements JsonSerializable<ImageGenerationContentFilterResults> {

    /*
     * Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     */
    @Generated
    private ContentFilterResult sexual;

    /*
     * Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     */
    @Generated
    private ContentFilterResult violence;

    /*
     * Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     */
    @Generated
    private ContentFilterResult hate;

    /*
     * Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     */
    @Generated
    private ContentFilterResult selfHarm;

    /**
     * Creates an instance of ImageGenerationContentFilterResults class.
     */
    @Generated
    private ImageGenerationContentFilterResults() {
    }

    /**
     * Get the sexual property: Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     *
     * @return the sexual value.
     */
    @Generated
    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    /**
     * Get the violence property: Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     *
     * @return the violence value.
     */
    @Generated
    public ContentFilterResult getViolence() {
        return this.violence;
    }

    /**
     * Get the hate property: Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     *
     * @return the hate value.
     */
    @Generated
    public ContentFilterResult getHate() {
        return this.hate;
    }

    /**
     * Get the selfHarm property: Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     *
     * @return the selfHarm value.
     */
    @Generated
    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", this.sexual);
        jsonWriter.writeJsonField("violence", this.violence);
        jsonWriter.writeJsonField("hate", this.hate);
        jsonWriter.writeJsonField("self_harm", this.selfHarm);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageGenerationContentFilterResults from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageGenerationContentFilterResults if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImageGenerationContentFilterResults.
     */
    @Generated
    public static ImageGenerationContentFilterResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageGenerationContentFilterResults deserializedImageGenerationContentFilterResults
                = new ImageGenerationContentFilterResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedImageGenerationContentFilterResults.sexual = ContentFilterResult.fromJson(reader);
                } else if ("violence".equals(fieldName)) {
                    deserializedImageGenerationContentFilterResults.violence = ContentFilterResult.fromJson(reader);
                } else if ("hate".equals(fieldName)) {
                    deserializedImageGenerationContentFilterResults.hate = ContentFilterResult.fromJson(reader);
                } else if ("self_harm".equals(fieldName)) {
                    deserializedImageGenerationContentFilterResults.selfHarm = ContentFilterResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedImageGenerationContentFilterResults;
        });
    }
}
