/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.ai.openai.models.AudioTranslationFormat;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;

public class AudioTranslationValidator {
    private static final ClientLogger LOGGER = new ClientLogger(AudioTranslationValidator.class);

    public static void validateAudioResponseFormatForTranslation(AudioTranslationOptions audioTranslationOptions) {
        ArrayList<AudioTranslationFormat> acceptedFormats = new ArrayList<AudioTranslationFormat>();
        acceptedFormats.add(AudioTranslationFormat.JSON);
        acceptedFormats.add(AudioTranslationFormat.VERBOSE_JSON);
        AudioTranslationFormat responseFormat = audioTranslationOptions.getResponseFormat();
        if (!acceptedFormats.contains((Object)responseFormat)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("This operation does not support the requested audio format: " + (Object)((Object)responseFormat) + ", supported formats: JSON, VERBOSE_JSON."));
        }
    }

    public static void validateAudioResponseFormatForTranslationText(AudioTranslationOptions audioTranslationOptions) {
        ArrayList<AudioTranslationFormat> acceptedFormats = new ArrayList<AudioTranslationFormat>();
        acceptedFormats.add(AudioTranslationFormat.TEXT);
        acceptedFormats.add(AudioTranslationFormat.VTT);
        acceptedFormats.add(AudioTranslationFormat.SRT);
        AudioTranslationFormat responseFormat = audioTranslationOptions.getResponseFormat();
        if (!acceptedFormats.contains((Object)responseFormat)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("This operation does not support the requested audio format: " + (Object)((Object)responseFormat) + ", supported formats: TEXT, VTT, SRT."));
        }
    }
}

