/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation.models;

import com.azure.ai.openai.models.OpenAIFile;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class FileListResponse
implements JsonSerializable<FileListResponse> {
    private final String object = "list";
    private final List<OpenAIFile> data;

    private FileListResponse(List<OpenAIFile> data) {
        this.data = data;
    }

    public String getObject() {
        return this.object;
    }

    public List<OpenAIFile> getData() {
        return this.data;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FileListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (FileListResponse)jsonReader.readObject(reader -> {
            List data = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> OpenAIFile.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new FileListResponse(data);
        });
    }
}

