/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataApiKeyAuthenticationOptions
extends OnYourDataAuthenticationOptions {
    private final String key;
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.API_KEY;

    public OnYourDataApiKeyAuthenticationOptions(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataApiKeyAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (OnYourDataApiKeyAuthenticationOptions)jsonReader.readObject(reader -> {
            String key = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.API_KEY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataApiKeyAuthenticationOptions deserializedOnYourDataApiKeyAuthenticationOptions = new OnYourDataApiKeyAuthenticationOptions(key);
            deserializedOnYourDataApiKeyAuthenticationOptions.type = type;
            return deserializedOnYourDataApiKeyAuthenticationOptions;
        });
    }
}

