// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The retrieved document.
 */
@Immutable
public final class AzureChatExtensionRetrievedDocument
    implements JsonSerializable<AzureChatExtensionRetrievedDocument> {

    /*
     * The content of the citation.
     */
    @Generated
    private final String content;

    /*
     * The title of the citation.
     */
    @Generated
    private String title;

    /*
     * The URL of the citation.
     */
    @Generated
    private String url;

    /*
     * The file path of the citation.
     */
    @Generated
    private String filepath;

    /*
     * The chunk ID of the citation.
     */
    @Generated
    private String chunkId;

    /*
     * The search queries used to retrieve the document.
     */
    @Generated
    private final List<String> searchQueries;

    /*
     * The index of the data source.
     */
    @Generated
    private final int dataSourceIndex;

    /*
     * The original search score of the retrieved document.
     */
    @Generated
    private Double originalSearchScore;

    /*
     * The rerank score of the retrieved document.
     */
    @Generated
    private Double rerankScore;

    /*
     * Represents the rationale for filtering the document. If the document does not undergo filtering,
     * this field will remain unset.
     */
    @Generated
    private AzureChatExtensionRetrieveDocumentFilterReason filterReason;

    /**
     * Creates an instance of AzureChatExtensionRetrievedDocument class.
     *
     * @param content the content value to set.
     * @param searchQueries the searchQueries value to set.
     * @param dataSourceIndex the dataSourceIndex value to set.
     */
    @Generated
    private AzureChatExtensionRetrievedDocument(String content, List<String> searchQueries, int dataSourceIndex) {
        this.content = content;
        this.searchQueries = searchQueries;
        this.dataSourceIndex = dataSourceIndex;
    }

    /**
     * Get the content property: The content of the citation.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the title property: The title of the citation.
     *
     * @return the title value.
     */
    @Generated
    public String getTitle() {
        return this.title;
    }

    /**
     * Get the url property: The URL of the citation.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the filepath property: The file path of the citation.
     *
     * @return the filepath value.
     */
    @Generated
    public String getFilepath() {
        return this.filepath;
    }

    /**
     * Get the chunkId property: The chunk ID of the citation.
     *
     * @return the chunkId value.
     */
    @Generated
    public String getChunkId() {
        return this.chunkId;
    }

    /**
     * Get the searchQueries property: The search queries used to retrieve the document.
     *
     * @return the searchQueries value.
     */
    @Generated
    public List<String> getSearchQueries() {
        return this.searchQueries;
    }

    /**
     * Get the dataSourceIndex property: The index of the data source.
     *
     * @return the dataSourceIndex value.
     */
    @Generated
    public int getDataSourceIndex() {
        return this.dataSourceIndex;
    }

    /**
     * Get the originalSearchScore property: The original search score of the retrieved document.
     *
     * @return the originalSearchScore value.
     */
    @Generated
    public Double getOriginalSearchScore() {
        return this.originalSearchScore;
    }

    /**
     * Get the rerankScore property: The rerank score of the retrieved document.
     *
     * @return the rerankScore value.
     */
    @Generated
    public Double getRerankScore() {
        return this.rerankScore;
    }

    /**
     * Get the filterReason property: Represents the rationale for filtering the document. If the document does not
     * undergo filtering,
     * this field will remain unset.
     *
     * @return the filterReason value.
     */
    @Generated
    public AzureChatExtensionRetrieveDocumentFilterReason getFilterReason() {
        return this.filterReason;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("search_queries", this.searchQueries,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeIntField("data_source_index", this.dataSourceIndex);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("filepath", this.filepath);
        jsonWriter.writeStringField("chunk_id", this.chunkId);
        jsonWriter.writeNumberField("rerank_score", this.rerankScore);
        jsonWriter.writeNumberField("original_search_score", this.originalSearchScore);
        jsonWriter.writeStringField("filter_reason", this.filterReason == null ? null : this.filterReason.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureChatExtensionRetrievedDocument from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureChatExtensionRetrievedDocument if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureChatExtensionRetrievedDocument.
     */
    @Generated
    public static AzureChatExtensionRetrievedDocument fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String content = null;
            List<String> searchQueries = null;
            int dataSourceIndex = 0;
            String title = null;
            String url = null;
            String filepath = null;
            String chunkId = null;
            Double rerankScore = null;
            Double originalSearchScore = null;
            AzureChatExtensionRetrieveDocumentFilterReason filterReason = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("search_queries".equals(fieldName)) {
                    searchQueries = reader.readArray(reader1 -> reader1.getString());
                } else if ("data_source_index".equals(fieldName)) {
                    dataSourceIndex = reader.getInt();
                } else if ("title".equals(fieldName)) {
                    title = reader.getString();
                } else if ("url".equals(fieldName)) {
                    url = reader.getString();
                } else if ("filepath".equals(fieldName)) {
                    filepath = reader.getString();
                } else if ("chunk_id".equals(fieldName)) {
                    chunkId = reader.getString();
                } else if ("rerank_score".equals(fieldName)) {
                    rerankScore = reader.getNullable(JsonReader::getDouble);
                } else if ("original_search_score".equals(fieldName)) {
                    originalSearchScore = reader.getNullable(JsonReader::getDouble);
                } else if ("filter_reason".equals(fieldName)) {
                    filterReason = AzureChatExtensionRetrieveDocumentFilterReason.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            AzureChatExtensionRetrievedDocument deserializedAzureChatExtensionRetrievedDocument
                = new AzureChatExtensionRetrievedDocument(content, searchQueries, dataSourceIndex);
            deserializedAzureChatExtensionRetrievedDocument.title = title;
            deserializedAzureChatExtensionRetrievedDocument.url = url;
            deserializedAzureChatExtensionRetrievedDocument.filepath = filepath;
            deserializedAzureChatExtensionRetrievedDocument.chunkId = chunkId;
            deserializedAzureChatExtensionRetrievedDocument.rerankScore = rerankScore;
            deserializedAzureChatExtensionRetrievedDocument.originalSearchScore = originalSearchScore;
            deserializedAzureChatExtensionRetrievedDocument.filterReason = filterReason;
            return deserializedAzureChatExtensionRetrievedDocument;
        });
    }
}
