// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A representation of the additional context information available when Azure OpenAI chat extensions are involved
 * in the generation of a corresponding chat completions response. This context information is only populated when
 * using an Azure OpenAI request configured to use a matching extension.
 */
@Immutable
public final class AzureChatExtensionsMessageContext implements JsonSerializable<AzureChatExtensionsMessageContext> {

    /**
     * Creates an instance of AzureChatExtensionsMessageContext class.
     */
    @Generated
    private AzureChatExtensionsMessageContext() {
    }

    /*
     * The contextual information associated with the Azure chat extensions used for a chat completions request.
     * These messages describe the data source retrievals, plugin invocations, and other intermediate steps taken in the
     * course of generating a chat completions response that was augmented by capabilities from Azure OpenAI chat
     * extensions.
     */
    @Generated
    private List<AzureChatExtensionDataSourceResponseCitation> citations;

    /*
     * The detected intent from the chat history, used to pass to the next turn to carry over the context.
     */
    @Generated
    private String intent;

    /**
     * Get the citations property: The contextual information associated with the Azure chat extensions used for a chat
     * completions request.
     * These messages describe the data source retrievals, plugin invocations, and other intermediate steps taken in the
     * course of generating a chat completions response that was augmented by capabilities from Azure OpenAI chat
     * extensions.
     *
     * @return the citations value.
     */
    @Generated
    public List<AzureChatExtensionDataSourceResponseCitation> getCitations() {
        return this.citations;
    }

    /**
     * Get the intent property: The detected intent from the chat history, used to pass to the next turn to carry over
     * the context.
     *
     * @return the intent value.
     */
    @Generated
    public String getIntent() {
        return this.intent;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("citations", this.citations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("intent", this.intent);
        jsonWriter.writeArrayField("all_retrieved_documents", this.allRetrievedDocuments,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureChatExtensionsMessageContext from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureChatExtensionsMessageContext if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureChatExtensionsMessageContext.
     */
    @Generated
    public static AzureChatExtensionsMessageContext fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureChatExtensionsMessageContext deserializedAzureChatExtensionsMessageContext
                = new AzureChatExtensionsMessageContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("citations".equals(fieldName)) {
                    List<AzureChatExtensionDataSourceResponseCitation> citations
                        = reader.readArray(reader1 -> AzureChatExtensionDataSourceResponseCitation.fromJson(reader1));
                    deserializedAzureChatExtensionsMessageContext.citations = citations;
                } else if ("intent".equals(fieldName)) {
                    deserializedAzureChatExtensionsMessageContext.intent = reader.getString();
                } else if ("all_retrieved_documents".equals(fieldName)) {
                    List<AzureChatExtensionRetrievedDocument> allRetrievedDocuments
                        = reader.readArray(reader1 -> AzureChatExtensionRetrievedDocument.fromJson(reader1));
                    deserializedAzureChatExtensionsMessageContext.allRetrievedDocuments = allRetrievedDocuments;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAzureChatExtensionsMessageContext;
        });
    }

    /*
     * All the retrieved documents.
     */
    @Generated
    private List<AzureChatExtensionRetrievedDocument> allRetrievedDocuments;

    /**
     * Get the allRetrievedDocuments property: All the retrieved documents.
     *
     * @return the allRetrievedDocuments value.
     */
    @Generated
    public List<AzureChatExtensionRetrievedDocument> getAllRetrievedDocuments() {
        return this.allRetrievedDocuments;
    }
}
