// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A structured chat content item containing an image reference.
 */
@Immutable
public final class ChatMessageImageContentItem extends ChatMessageContentItem {

    /*
     * An internet location, which must be accessible to the model,from which the image may be retrieved.
     */
    @Generated
    private final ChatMessageImageUrl imageUrl;

    /**
     * Creates an instance of ChatMessageImageContentItem class.
     *
     * @param imageUrl the imageUrl value to set.
     */
    @Generated
    public ChatMessageImageContentItem(ChatMessageImageUrl imageUrl) {
        this.imageUrl = imageUrl;
    }

    /**
     * Get the imageUrl property: An internet location, which must be accessible to the model,from which the image may
     * be retrieved.
     *
     * @return the imageUrl value.
     */
    @Generated
    public ChatMessageImageUrl getImageUrl() {
        return this.imageUrl;
    }

    /*
     * The discriminated object type.
     */
    @Generated
    private String type = "image_url";

    /**
     * Get the type property: The discriminated object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_url", this.imageUrl);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatMessageImageContentItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatMessageImageContentItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatMessageImageContentItem.
     */
    @Generated
    public static ChatMessageImageContentItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatMessageImageUrl imageUrl = null;
            String type = "image_url";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_url".equals(fieldName)) {
                    imageUrl = ChatMessageImageUrl.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatMessageImageContentItem deserializedChatMessageImageContentItem
                = new ChatMessageImageContentItem(imageUrl);
            deserializedChatMessageImageContentItem.type = type;
            return deserializedChatMessageImageContentItem;
        });
    }
}
