// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Developer-provided instructions that the model should follow, regardless of messages sent by the user.
 * With o1 models and newer, `developer` messages replace the previous `system` messages.".
 */
@Fluent
public final class ChatRequestDeveloperMessage extends ChatRequestMessage {

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.DEVELOPER;

    /*
     * An array of content parts with a defined type. For developer messages, only type `text` is supported.
     */
    @Generated
    private final BinaryData content;

    /*
     * An optional name for the participant. Provides the model information to differentiate between participants of the
     * same role.
     */
    @Generated
    private String name;

    /**
     * Creates an instance of ChatRequestDeveloperMessage class.
     *
     * @param content the content value to set.
     */
    @Generated
    public ChatRequestDeveloperMessage(BinaryData content) {
        this.content = content;
    }

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: An array of content parts with a defined type. For developer messages, only type `text`
     * is supported.
     *
     * @return the content value.
     */
    @Generated
    public BinaryData getContent() {
        return this.content;
    }

    /**
     * Get the name property: An optional name for the participant. Provides the model information to differentiate
     * between participants of the same role.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: An optional name for the participant. Provides the model information to differentiate
     * between participants of the same role.
     *
     * @param name the name value to set.
     * @return the ChatRequestDeveloperMessage object itself.
     */
    @Generated
    public ChatRequestDeveloperMessage setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestDeveloperMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestDeveloperMessage if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatRequestDeveloperMessage.
     */
    @Generated
    public static ChatRequestDeveloperMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.DEVELOPER;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatRequestDeveloperMessage deserializedChatRequestDeveloperMessage
                = new ChatRequestDeveloperMessage(content);
            deserializedChatRequestDeveloperMessage.role = role;
            deserializedChatRequestDeveloperMessage.name = name;
            return deserializedChatRequestDeveloperMessage;
        });
    }
}
