// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The representation of a single prompt completion as part of an overall completions request.
 * Generally, `n` choices are generated per provided prompt with a default value of 1.
 * Token limits and other settings may limit the number of choices generated.
 */
@Immutable
public final class Choice implements JsonSerializable<Choice> {

    /*
     * The generated text for a given completions prompt.
     */
    @Generated
    private final String text;

    /*
     * The ordered index associated with this completions choice.
     */
    @Generated
    private final int index;

    /*
     * The log probabilities model for tokens associated with this completions choice.
     */
    @Generated
    private final CompletionsLogProbabilityModel logprobs;

    /*
     * Reason for finishing
     */
    @Generated
    private final CompletionsFinishReason finishReason;

    /**
     * Creates an instance of Choice class.
     *
     * @param text the text value to set.
     * @param index the index value to set.
     * @param logprobs the logprobs value to set.
     * @param finishReason the finishReason value to set.
     */
    @Generated
    private Choice(String text, int index, CompletionsLogProbabilityModel logprobs,
        CompletionsFinishReason finishReason) {
        this.text = text;
        this.index = index;
        this.logprobs = logprobs;
        this.finishReason = finishReason;
    }

    /**
     * Get the text property: The generated text for a given completions prompt.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the index property: The ordered index associated with this completions choice.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the logprobs property: The log probabilities model for tokens associated with this completions choice.
     *
     * @return the logprobs value.
     */
    @Generated
    public CompletionsLogProbabilityModel getLogprobs() {
        return this.logprobs;
    }

    /**
     * Get the finishReason property: Reason for finishing.
     *
     * @return the finishReason value.
     */
    @Generated
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    /*
     * Information about the content filtering category (hate, sexual, violence, self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     */
    @Generated
    private ContentFilterResultsForChoice contentFilterResults;

    /**
     * Get the contentFilterResults property: Information about the content filtering category (hate, sexual, violence,
     * self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ContentFilterResultsForChoice getContentFilterResults() {
        return this.contentFilterResults;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeJsonField("logprobs", this.logprobs);
        jsonWriter.writeStringField("finish_reason", this.finishReason == null ? null : this.finishReason.toString());
        jsonWriter.writeJsonField("content_filter_results", this.contentFilterResults);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Choice from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Choice if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Choice.
     */
    @Generated
    public static Choice fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            int index = 0;
            CompletionsLogProbabilityModel logprobs = null;
            CompletionsFinishReason finishReason = null;
            ContentFilterResultsForChoice contentFilterResults = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("logprobs".equals(fieldName)) {
                    logprobs = CompletionsLogProbabilityModel.fromJson(reader);
                } else if ("finish_reason".equals(fieldName)) {
                    finishReason = CompletionsFinishReason.fromString(reader.getString());
                } else if ("content_filter_results".equals(fieldName)) {
                    contentFilterResults = ContentFilterResultsForChoice.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            Choice deserializedChoice = new Choice(text, index, logprobs, finishReason);
            deserializedChoice.contentFilterResults = contentFilterResults;
            return deserializedChoice;
        });
    }
}
