// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The CompletionsUsagePromptTokensDetails model.
 */
@Immutable
public final class CompletionsUsagePromptTokensDetails
    implements JsonSerializable<CompletionsUsagePromptTokensDetails> {

    /*
     * Cached tokens present in the prompt.
     */
    @Generated
    private Integer cachedTokens;

    /**
     * Creates an instance of CompletionsUsagePromptTokensDetails class.
     */
    @Generated
    private CompletionsUsagePromptTokensDetails() {
    }

    /**
     * Get the cachedTokens property: Cached tokens present in the prompt.
     *
     * @return the cachedTokens value.
     */
    @Generated
    public Integer getCachedTokens() {
        return this.cachedTokens;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("audio_tokens", this.audioTokens);
        jsonWriter.writeNumberField("cached_tokens", this.cachedTokens);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CompletionsUsagePromptTokensDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CompletionsUsagePromptTokensDetails if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CompletionsUsagePromptTokensDetails.
     */
    @Generated
    public static CompletionsUsagePromptTokensDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CompletionsUsagePromptTokensDetails deserializedCompletionsUsagePromptTokensDetails
                = new CompletionsUsagePromptTokensDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("audio_tokens".equals(fieldName)) {
                    deserializedCompletionsUsagePromptTokensDetails.audioTokens
                        = reader.getNullable(JsonReader::getInt);
                } else if ("cached_tokens".equals(fieldName)) {
                    deserializedCompletionsUsagePromptTokensDetails.cachedTokens
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedCompletionsUsagePromptTokensDetails;
        });
    }

    /*
     * Audio input tokens present in the prompt.
     */
    @Generated
    private Integer audioTokens;

    /**
     * Get the audioTokens property: Audio input tokens present in the prompt.
     *
     * @return the audioTokens value.
     */
    @Generated
    public Integer getAudioTokens() {
        return this.audioTokens;
    }
}
