// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a span within generated completion text.
 */
@Immutable
public final class ContentFilterCompletionTextSpanResult
    implements JsonSerializable<ContentFilterCompletionTextSpanResult> {

    /*
     * A value indicating whether or not the content has been filtered.
     */
    @Generated
    private final boolean filtered;

    /*
     * A value indicating whether detection occurred, irrespective of severity or whether the content was filtered.
     */
    @Generated
    private final boolean detected;

    /*
     * The collection of completion text spans.
     */
    @Generated
    private final List<ContentFilterCompletionTextSpan> details;

    /**
     * Creates an instance of ContentFilterCompletionTextSpanResult class.
     *
     * @param filtered the filtered value to set.
     * @param detected the detected value to set.
     * @param details the details value to set.
     */
    @Generated
    private ContentFilterCompletionTextSpanResult(boolean filtered, boolean detected,
        List<ContentFilterCompletionTextSpan> details) {
        this.filtered = filtered;
        this.detected = detected;
        this.details = details;
    }

    /**
     * Get the filtered property: A value indicating whether or not the content has been filtered.
     *
     * @return the filtered value.
     */
    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }

    /**
     * Get the detected property: A value indicating whether detection occurred, irrespective of severity or whether the
     * content was filtered.
     *
     * @return the detected value.
     */
    @Generated
    public boolean isDetected() {
        return this.detected;
    }

    /**
     * Get the details property: The collection of completion text spans.
     *
     * @return the details value.
     */
    @Generated
    public List<ContentFilterCompletionTextSpan> getDetails() {
        return this.details;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeBooleanField("detected", this.detected);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterCompletionTextSpanResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterCompletionTextSpanResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentFilterCompletionTextSpanResult.
     */
    @Generated
    public static ContentFilterCompletionTextSpanResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            boolean detected = false;
            List<ContentFilterCompletionTextSpan> details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                } else if ("detected".equals(fieldName)) {
                    detected = reader.getBoolean();
                } else if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ContentFilterCompletionTextSpan.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new ContentFilterCompletionTextSpanResult(filtered, detected, details);
        });
    }
}
